/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d.content.blocks.stirling_engine.flywheel;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.lopyluna.create_d2d.content.blocks.stirling_engine.flywheel.PoweredFlywheelBE;
import dev.lopyluna.create_d2d.content.blocks.stirling_engine.flywheel.PoweredFlywheelBlock;
import dev.lopyluna.create_d2d.register.client.DesiresPartialModels;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PoweredFlywheelVisual
extends KineticBlockEntityVisual<PoweredFlywheelBE>
implements SimpleDynamicVisual {
    protected final RotatingInstance shaft;
    protected final TransformedInstance wheel;
    protected float lastAngle = Float.NaN;
    protected final Matrix4f baseTransform = new Matrix4f();

    public PoweredFlywheelVisual(VisualizationContext context, PoweredFlywheelBE blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        Direction.Axis axis = this.rotationAxis();
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstance();
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(axis).setChanged();
        this.wheel = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)DesiresPartialModels.FLYWHEEL)).createInstance();
        Direction facing = (Direction)this.blockState.getValue((Property)PoweredFlywheelBlock.FACING);
        ((TransformedInstance)((TransformedInstance)this.wheel.translate((Vec3i)this.getVisualPosition())).center()).rotate((Quaternionfc)new Quaternionf().rotateTo(1.0f, 0.0f, 0.0f, (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()));
        this.baseTransform.set((Matrix4fc)this.wheel.pose);
        this.animate(blockEntity.angle);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTicks = ctx.partialTick();
        float speed = ((PoweredFlywheelBE)this.blockEntity).visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = ((PoweredFlywheelBE)this.blockEntity).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        ((TransformedInstance)this.wheel.setTransform((Matrix4fc)this.baseTransform).rotateX(AngleHelper.rad((double)angle)).uncenter()).setChanged();
    }

    public void update(float pt) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.shaft, this.wheel});
    }

    protected void _delete() {
        this.shaft.delete();
        this.wheel.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.shaft);
        consumer.accept((Instance)this.wheel);
    }
}

