/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d.content.blocks.roll_table;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.lopyluna.create_d2d.content.blocks.roll_table.RollTableBE;
import dev.lopyluna.create_d2d.register.DesiresBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RollTableBlock
extends Block
implements IWrenchable,
IBE<RollTableBE> {
    public RollTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> {
            if (!stack.isEmpty()) {
                DirectBeltInputBehaviour inputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                ItemStack remainder = inputBehaviour.handleInsertion(stack, player.getDirection(), false);
                stack.transmuteCopy((ItemLike)remainder.getItem(), remainder.getCount());
                if (remainder.isEmpty()) {
                    stack.setCount(0);
                }
                return ItemInteractionResult.SUCCESS;
            }
            ItemStack heldItemStack = be.getHeldItemStack();
            if (!level.isClientSide && !heldItemStack.isEmpty()) {
                player.getInventory().placeItemBackInInventory(heldItemStack);
                be.heldItem = null;
                be.notifyUpdate();
            }
            return ItemInteractionResult.SUCCESS;
        });
    }

    @ParametersAreNonnullByDefault
    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        super.updateEntityAfterFallOn(level, entity);
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (!entity.isAlive()) {
            return;
        }
        if (entity.level().isClientSide) {
            return;
        }
        DirectBeltInputBehaviour inputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)entity.blockPosition(), (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        Vec3 deltaMovement = entity.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
        Direction nearest = Direction.getNearest((double)deltaMovement.x, (double)deltaMovement.y, (double)deltaMovement.z);
        ItemStack remainder = inputBehaviour.handleInsertion(itemEntity.getItem(), nearest, false);
        itemEntity.setItem(remainder);
        if (remainder.isEmpty()) {
            itemEntity.discard();
        }
    }

    @ParametersAreNonnullByDefault
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            ItemStack heldItemStack = be.getHeldItemStack();
            if (!heldItemStack.isEmpty()) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)heldItemStack);
            }
        });
        worldIn.removeBlockEntity(pos);
    }

    public void setPlacedBy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy((Level)pLevel, (BlockPos)pPos, (LivingEntity)pPlacer);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AllShapes.CASING_13PX.get(Direction.UP);
    }

    public Class<RollTableBE> getBlockEntityClass() {
        return RollTableBE.class;
    }

    public BlockEntityType<? extends RollTableBE> getBlockEntityType() {
        return (BlockEntityType)DesiresBETypes.ROLL_TABLE.get();
    }

    @ParametersAreNonnullByDefault
    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

