/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d.content.blocks.hydraulic_press;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.lopyluna.create_d2d.content.blocks.hydraulic_press.HydraulicPressBlock;
import dev.lopyluna.create_d2d.content.blocks.hydraulic_press.HydraulicPressingBehavior;
import dev.lopyluna.create_d2d.register.DesiresBETypes;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class HydraulicPressBE
extends BasinOperatingBlockEntity
implements PressingBehaviour.PressingBehaviourSpecifics {
    private static final Object compressingRecipesKey = new Object();
    public HydraulicPressingBehavior pressingBehaviour;
    public SmartFluidTankBehaviour tank;

    public HydraulicPressBE(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        SmartFluidTank handler = this.tank.getPrimaryHandler();
        int capacity = handler.getCapacity();
        FluidStack fluidStack = handler.getFluid();
        if (!fluidStack.isEmpty()) {
            int amount = fluidStack.getAmount();
            CreateLang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)amount).add(mb).style(1000 > amount ? ChatFormatting.RED : ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)capacity).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        } else {
            CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(CreateLang.number((double)capacity).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        }
        CreateLang.translate((String)"tooltip.stressImpact", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float stressTotal = this.calculateStressApplied() * Math.abs(this.getTheoreticalSpeed());
        CreateLang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)DesiresBETypes.HYDRAULIC_PRESS.get(), (be, context) -> {
            if (context != null && context.getAxis() != ((Direction)be.getBlockState().getValue(HydraulicPressBlock.HORIZONTAL_FACING)).getAxis() && context.getAxis() != Direction.Axis.Y) {
                return be.tank.getCapability();
            }
            return null;
        });
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, -1.5, 0.0).expandTowards(0.0, 1.0, 0.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)3000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        this.pressingBehaviour = new HydraulicPressingBehavior(this);
        behaviours.add((BlockEntityBehaviour)this.pressingBehaviour);
    }

    public void onItemPressed() {
        this.award(AllAdvancements.PRESS);
    }

    public boolean canProcessInBulk() {
        return true;
    }

    public int getParticleAmount() {
        return 15;
    }

    public float getKineticSpeed() {
        return this.getSpeed() * 0.25f;
    }

    protected boolean isRunning() {
        return this.pressingBehaviour.running;
    }

    protected void onBasinRemoved() {
        this.pressingBehaviour.particleItems.clear();
        this.pressingBehaviour.running = false;
        this.pressingBehaviour.runningTicks = 0;
        this.sendData();
    }

    public Optional<RecipeHolder<PressingRecipe>> getRecipe(ItemStack item) {
        if (this.level == null) {
            return Optional.empty();
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (ItemStack)item, (RecipeType)AllRecipeTypes.PRESSING.getType(), PressingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        return AllRecipeTypes.PRESSING.find((RecipeInput)new SingleRecipeInput(item), this.level);
    }

    public static boolean canCompress(Recipe<?> recipe) {
        if (!(recipe instanceof CraftingRecipe) || !((Boolean)AllConfigs.server().recipes.allowShapedSquareInPress.get()).booleanValue()) {
            return false;
        }
        NonNullList ingredients = recipe.getIngredients();
        return (ingredients.size() == 4 || ingredients.size() == 9) && ItemHelper.matchAllIngredients((NonNullList)ingredients);
    }

    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> recipe) {
        return recipe.value() instanceof CraftingRecipe && !(recipe.value() instanceof MechanicalCraftingRecipe) && HydraulicPressBE.canCompress(recipe.value()) && !AllRecipeTypes.shouldIgnoreInAutomation(recipe) || recipe.value().getType() == AllRecipeTypes.COMPACTING.getType();
    }

    protected Object getRecipeCacheKey() {
        return compressingRecipesKey;
    }

    protected boolean updateBasin() {
        if (this.isNotReady()) {
            return true;
        }
        if (!this.isSpeedRequirementFulfilled()) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.isRunning()) {
            return true;
        }
        if (this.level == null || this.level.isClientSide) {
            return true;
        }
        Optional basin = this.getBasin();
        if (basin.filter(BasinBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        List recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = (Recipe)recipes.getFirst();
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    public void startProcessingBasin() {
        if (this.isNotReady()) {
            return;
        }
        if (this.pressingBehaviour.running && this.pressingBehaviour.runningTicks <= 120) {
            return;
        }
        super.startProcessingBasin();
        this.pressingBehaviour.start(PressingBehaviour.Mode.BASIN);
    }

    public void onPressingCompleted() {
        if (this.pressingBehaviour.onBasin() && this.matchBasinRecipe(this.currentRecipe) && this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isPresent()) {
            this.startProcessingBasin();
        } else {
            this.basinChecker.scheduleUpdate();
        }
    }

    public boolean tryProcessInBasin(boolean simulate) {
        if (this.isNotReady()) {
            return false;
        }
        this.applyBasinRecipe();
        Optional basin = this.getBasin();
        if (basin.isPresent()) {
            SmartInventory inputs = ((BasinBlockEntity)basin.get()).getInputInventory();
            for (int slot = 0; slot < inputs.getSlots(); ++slot) {
                ItemStack stackInSlot = inputs.getItem(slot);
                if (stackInSlot.isEmpty()) continue;
                this.pressingBehaviour.particleItems.add(stackInSlot);
            }
        }
        return true;
    }

    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<RecipeHolder<PressingRecipe>> recipe = this.getRecipe(input.stack);
        if (recipe.isEmpty()) {
            return false;
        }
        if (this.isNotReady()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.level == null) {
            return false;
        }
        this.pressingBehaviour.particleItems.add(input.stack);
        List outputs = RecipeApplier.applyRecipeOn((Level)this.level, (ItemStack)(this.canProcessInBulk() ? input.stack : input.stack.copyWithCount(1)), recipe.get());
        for (ItemStack created : outputs) {
            if (created.isEmpty()) continue;
            this.onItemPressed();
            break;
        }
        outputList.addAll(outputs);
        return true;
    }

    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        ItemStack item = itemEntity.getItem();
        Optional<RecipeHolder<PressingRecipe>> recipe = this.getRecipe(item);
        if (recipe.isEmpty()) {
            return false;
        }
        if (this.isNotReady()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.level == null) {
            return false;
        }
        ItemStack itemCreated = ItemStack.EMPTY;
        this.pressingBehaviour.particleItems.add(item);
        if (this.canProcessInBulk() || item.getCount() == 1) {
            RecipeApplier.applyRecipeOn((ItemEntity)itemEntity, (Recipe)recipe.get().value());
            itemCreated = itemEntity.getItem().copy();
        } else {
            for (ItemStack result : RecipeApplier.applyRecipeOn((Level)this.level, (ItemStack)item.copyWithCount(1), recipe.get())) {
                if (itemCreated.isEmpty()) {
                    itemCreated = result.copy();
                }
                ItemEntity created = new ItemEntity(this.level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), result);
                created.setDefaultPickUpDelay();
                created.setDeltaMovement(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)this.level.random, (float)0.05f));
                this.level.addFreshEntity((Entity)created);
            }
            item.shrink(1);
        }
        if (!itemCreated.isEmpty()) {
            this.onItemPressed();
        }
        return true;
    }

    private FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    public boolean isNotReady() {
        return !this.isSpeedRequirementFulfilled() || this.getCurrentFluidInTank().getFluidType().isLighterThanAir() || 1000 > this.tank.getPrimaryHandler().getFluidAmount();
    }

    public void processRecipe() {
        FluidStack fluid = this.getCurrentFluidInTank();
        fluid.setAmount(fluid.getAmount() - 1000);
        this.tank.getPrimaryHandler().setFluid(fluid);
    }
}

