/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.create_d2d;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.lopyluna.create_d2d.DesiresDatagen;
import dev.lopyluna.create_d2d.content.blocks.stirling_engine.StirlingEngineBlock;
import dev.lopyluna.create_d2d.register.DesiresBETypes;
import dev.lopyluna.create_d2d.register.DesiresBlocks;
import dev.lopyluna.create_d2d.register.DesiresConfigs;
import dev.lopyluna.create_d2d.register.DesiresCreativeTabs;
import dev.lopyluna.create_d2d.register.DesiresFluids;
import dev.lopyluna.create_d2d.register.DesiresItems;
import dev.lopyluna.create_d2d.register.DesiresStoneTypes;
import dev.lopyluna.create_d2d.register.DesiresTags;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;

@Mod(value="create_d2d")
public class DesiresCreate {
    public static final String NAME = "Create: Desires 2 Dreams";
    public static final String MOD_ID = "create_d2d";
    public static final CreateRegistrate REG = (CreateRegistrate)CreateRegistrate.create((String)"create_d2d").defaultCreativeTab((ResourceKey)null);

    public DesiresCreate(IEventBus modEventBus, ModContainer modContainer) {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        REG.registerEventListeners(modEventBus);
        DesiresCreativeTabs.register(modEventBus);
        DesiresTags.init();
        DesiresItems.register();
        DesiresBlocks.register();
        DesiresBETypes.register();
        DesiresFluids.register();
        DesiresStoneTypes.register(REG);
        DesiresConfigs.register(modLoadingContext, modContainer);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(DesiresCreate::init);
        modEventBus.addListener(EventPriority.LOWEST, DesiresDatagen::gatherData);
    }

    public static void init(FMLCommonSetupEvent event) {
        DesiresFluids.registerFluidInteractions();
    }

    public static void onRegister(RegisterEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        ItemStack stack;
        Block block;
        if (event.getTabKey().equals(DesiresCreativeTabs.BASE_CREATIVE_TAB.getKey())) {
            for (RegistryEntry entry : REG.getAll(Registries.ITEM)) {
                Item item = (Item)entry.get();
                if (item instanceof BlockItem || item instanceof BucketItem) continue;
                event.accept((ItemLike)item);
            }
            for (RegistryEntry entry : REG.getAll(Registries.BLOCK)) {
                block = (Block)entry.get();
                stack = block.asItem().getDefaultInstance();
                if (block.asItem() == Items.AIR || DesiresTags.ItemTags.DYED_BLOCKS.matches(stack) || stack.is(DesiresTags.ItemTags.PALETTE_BLOCKS.tag)) continue;
                event.accept((ItemLike)block);
            }
            for (RegistryEntry entry : REG.getAll(Registries.FLUID)) {
                Fluid fluid = (Fluid)entry.get();
                if (!fluid.defaultFluidState().isSource()) continue;
                event.accept((ItemLike)fluid.getBucket());
            }
        }
        if (event.getTabKey().equals(DesiresCreativeTabs.PALETTES_CREATIVE_TAB.getKey())) {
            for (RegistryEntry entry : REG.getAll(Registries.BLOCK)) {
                block = (Block)entry.get();
                stack = block.asItem().getDefaultInstance();
                if (block.asItem() == Items.AIR || !stack.is(DesiresTags.ItemTags.PALETTE_BLOCKS.tag) && !DesiresTags.ItemTags.DYED_BLOCKS.matches(stack)) continue;
                event.accept(stack);
            }
        }
    }

    public static LangBuilder lang() {
        return new LangBuilder(MOD_ID);
    }

    public static ResourceLocation loc(String loc) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)loc);
    }

    public static ResourceLocation emptyLoc() {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"empty");
    }

    @Nullable
    public static KineticStats create(Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && ((block = (blockItem = (BlockItem)item).getBlock()) instanceof IRotate || block instanceof StirlingEngineBlock)) {
            return new KineticStats(block);
        }
        return null;
    }

    static {
        REG.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)DesiresCreate.create(item))));
    }
}

