/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.sound.download;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.ProgressTrackingInputStream;
import gg.moonflower.etched.common.sound.download.SourceRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.Nullable;

public class BandcampSource
implements SoundDownloadSource {
    private static final Pattern DATA_PATTERN = Pattern.compile("data-tralbum=\"([^\"]+)\"");
    private static final Component BRAND = Component.translatable((String)"sound_source.etched.bandcamp").withStyle(style -> style.withColor(TextColor.fromRgb((int)4684167)));
    private final Map<String, Boolean> validCache = new WeakHashMap<String, Boolean>();

    private InputStream get(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy) throws IOException {
        if (progressListener != null) {
            progressListener.progressStartRequest((Component)Component.translatable((String)"sound_source.etched.requesting", (Object[])new Object[]{this.getApiName()}));
        }
        try {
            URL uRL = new URI(url).toURL();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            httpURLConnection.setInstanceFollowRedirects(true);
            Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            long size = httpURLConnection.getContentLengthLong();
            int response = httpURLConnection.getResponseCode();
            if (response != 200) {
                throw new IOException(response + " " + httpURLConnection.getResponseMessage());
            }
            return size != -1L && progressListener != null ? new ProgressTrackingInputStream(httpURLConnection.getInputStream(), size, progressListener) : httpURLConnection.getInputStream();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private <T> T resolve(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, SourceRequest<T> function) throws IOException, URISyntaxException, JsonParseException {
        try (InputStream stream = this.get(url, progressListener, proxy);){
            String raw;
            Matcher dataMatcher = DATA_PATTERN.matcher(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8));
            String string = raw = dataMatcher.find() ? dataMatcher.group(1) : null;
            if (raw == null) {
                throw new IOException("Failed to find properties");
            }
            JsonObject json = JsonParser.parseString((String)StringEscapeUtils.unescapeHtml4((String)raw)).getAsJsonObject();
            String type = GsonHelper.getAsString((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"current"), (String)"type");
            if (!"track".equals(type) && !"album".equals(type)) {
                throw new IOException("URL is not a track or album");
            }
            T t = function.process(json);
            return t;
        }
    }

    @Nullable
    private String getTrackUrl(JsonObject fileJson) {
        if (fileJson.has("mp3-128")) {
            return GsonHelper.getAsString((JsonObject)fileJson, (String)"mp3-128");
        }
        return null;
    }

    @Override
    public Collection<URL> resolveUrl(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy) throws IOException, URISyntaxException, JsonParseException {
        return this.resolve(url, progressListener, proxy, json -> {
            if (progressListener != null) {
                progressListener.progressStartRequest(RESOLVING_TRACKS);
            }
            JsonArray trackInfoArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"trackinfo");
            ArrayList<URL> trackUrls = new ArrayList<URL>(trackInfoArray.size());
            for (int i = 0; i < trackInfoArray.size(); ++i) {
                JsonObject trackInfoJson = GsonHelper.convertToJsonObject((JsonElement)trackInfoArray.get(i), (String)("trackinfo[" + i + "]"));
                JsonObject fileJson = GsonHelper.getAsJsonObject((JsonObject)trackInfoJson, (String)"file");
                String trackUrl = this.getTrackUrl(fileJson);
                if (trackUrl == null) continue;
                trackUrls.add(new URI(trackUrl).toURL());
            }
            return trackUrls;
        });
    }

    @Override
    public Collection<TrackData> resolveTracks(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy) throws IOException, URISyntaxException, JsonParseException {
        return this.resolve(url, progressListener, proxy, json -> {
            int urlEnd = url.indexOf(".com/");
            if (urlEnd == -1) {
                urlEnd = url.length() - 4;
            }
            JsonObject current = GsonHelper.getAsJsonObject((JsonObject)json, (String)"current");
            String artist = StringEscapeUtils.unescapeHtml4((String)GsonHelper.getAsString((JsonObject)json, (String)"artist"));
            String title = StringEscapeUtils.unescapeHtml4((String)GsonHelper.getAsString((JsonObject)current, (String)"title"));
            String type = GsonHelper.getAsString((JsonObject)current, (String)"type");
            if ("album".equals(type)) {
                JsonArray trackInfoJson = GsonHelper.getAsJsonArray((JsonObject)json, (String)"trackinfo");
                ArrayList<TrackData> tracks = new ArrayList<TrackData>(trackInfoJson.size());
                tracks.add(new TrackData(url, artist, (Component)Component.literal((String)title)));
                for (int i = 0; i < trackInfoJson.size(); ++i) {
                    JsonObject trackJson = GsonHelper.convertToJsonObject((JsonElement)trackInfoJson.get(i), (String)("trackinfo[" + i + "]"));
                    String trackUrl = url.substring(0, urlEnd + 4) + GsonHelper.getAsString((JsonObject)trackJson, (String)"title_link");
                    String trackArtist = trackJson.has("artist") && !trackJson.get("artist").isJsonNull() ? StringEscapeUtils.unescapeHtml4((String)GsonHelper.getAsString((JsonObject)trackJson, (String)"artist", (String)artist)) : artist;
                    String trackTitle = StringEscapeUtils.unescapeHtml4((String)GsonHelper.getAsString((JsonObject)trackJson, (String)"title"));
                    tracks.add(new TrackData(trackUrl, trackArtist, (Component)Component.literal((String)trackTitle)));
                }
                return tracks;
            }
            return Collections.singleton(new TrackData(url, artist, (Component)Component.literal((String)title)));
        });
    }

    @Override
    public Optional<String> resolveAlbumCover(String url, @Nullable DownloadProgressListener progressListener, Proxy proxy, ResourceManager resourceManager) throws IOException, URISyntaxException, JsonParseException {
        return this.resolve(url, progressListener, proxy, json -> {
            JsonObject current = GsonHelper.getAsJsonObject((JsonObject)json, (String)"current");
            if (!current.has("art_id") || current.get("art_id").isJsonNull()) {
                return Optional.empty();
            }
            return Optional.of("https://f4.bcbits.com/img/a" + String.valueOf(current.get("art_id")) + "_1.jpg");
        });
    }

    @Override
    public boolean isValidUrl(String url) {
        return this.validCache.computeIfAbsent(url, key -> {
            try {
                String host = new URI((String)key).getHost();
                return host != null && host.endsWith("bandcamp.com");
            }
            catch (URISyntaxException e) {
                return false;
            }
        });
    }

    @Override
    public boolean isTemporary(String url) {
        return true;
    }

    @Override
    public String getApiName() {
        return "Bandcamp";
    }

    @Override
    public Optional<Component> getBrandText(String url) {
        return Optional.of(BRAND);
    }
}

