/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.entity;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.core.registry.EtchedEntities;
import gg.moonflower.etched.core.registry.EtchedItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class MinecartJukebox
extends AbstractMinecart
implements WorldlyContainer {
    private static final EntityDataAccessor<Boolean> DATA_ID_HAS_RECORD = SynchedEntityData.defineId(MinecartJukebox.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int[] SLOTS = new int[]{0};
    private ItemStack record = ItemStack.EMPTY;

    public MinecartJukebox(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public MinecartJukebox(Level level, double d, double e, double f) {
        super(EtchedEntities.JUKEBOX_MINECART.get(), level, d, e, f);
    }

    private void startPlaying(ItemStack stack, boolean restart) {
        if (PlayableRecord.isPlayableRecord(stack)) {
            PlayableRecord.playEntityRecord((Entity)this, stack, restart);
            this.entityData.set(DATA_ID_HAS_RECORD, (Object)true);
        }
    }

    private void stopPlaying() {
        if (((Boolean)this.entityData.get(DATA_ID_HAS_RECORD)).booleanValue()) {
            PlayableRecord.stopEntityRecord((Entity)this);
            this.entityData.set(DATA_ID_HAS_RECORD, (Object)false);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_HAS_RECORD, (Object)false);
    }

    public void tick() {
        SoundInstance instance;
        super.tick();
        if (this.level().isClientSide() && this.random.nextInt(6) == 0 && (instance = SoundTracker.getEntitySound(this.getId())) != null && Minecraft.getInstance().getSoundManager().isActive(instance)) {
            this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, this.getX(), this.getY() + 1.2, this.getZ(), (double)this.random.nextInt(25) / 24.0, 0.0, 0.0);
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (((Boolean)this.entityData.get(DATA_ID_HAS_RECORD)).booleanValue()) {
            if (!this.level().isClientSide() && !this.record.isEmpty()) {
                ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY() + (double)this.getBbHeight() + 0.2, this.getZ(), this.record.copy());
                itemEntity.setDefaultPickUpDelay();
                this.level().addFreshEntity((Entity)itemEntity);
                this.clearContent();
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (PlayableRecord.isPlayableRecord(stack)) {
            if (!this.level().isClientSide()) {
                this.setItem(0, stack.copy());
                stack.shrink(1);
                player.awardStat(Stats.PLAY_RECORD);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void activateMinecart(int x, int y, int z, boolean powered) {
        if (!this.record.isEmpty()) {
            this.startPlaying(this.record.copy(), true);
        }
    }

    public void destroy(DamageSource damageSource) {
        super.destroy(damageSource);
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)this.record);
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide() && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(reason);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("HasRecord", ((Boolean)this.entityData.get(DATA_ID_HAS_RECORD)).booleanValue());
        if (!this.record.isEmpty()) {
            nbt.put("RecordItem", this.record.save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(DATA_ID_HAS_RECORD, (Object)nbt.getBoolean("HasRecord"));
        if (nbt.contains("RecordItem", 10)) {
            this.record = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)nbt.getCompound("RecordItem"));
        }
    }

    public BlockState getDefaultDisplayBlockState() {
        return (BlockState)Blocks.JUKEBOX.defaultBlockState().setValue((Property)JukeboxBlock.HAS_RECORD, (Comparable)((Boolean)this.entityData.get(DATA_ID_HAS_RECORD)));
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public Item getDropItem() {
        return (Item)EtchedItems.JUKEBOX_MINECART.get();
    }

    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.SPAWNER;
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return PlayableRecord.isPlayableRecord(stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.record.isEmpty();
    }

    public ItemStack getItem(int index) {
        return index == 0 ? this.record : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int index, int count) {
        if (index != 0) {
            return ItemStack.EMPTY;
        }
        ItemStack split = this.record.split(count);
        this.setChanged();
        if (this.record.isEmpty()) {
            this.stopPlaying();
        }
        return split;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.removeItem(index, this.record.getCount());
    }

    public void setItem(int index, ItemStack stack) {
        if (index == 0) {
            if (!this.record.isEmpty()) {
                this.stopPlaying();
            }
            this.startPlaying(stack.copy(), false);
            this.record = stack;
        }
    }

    public boolean stillValid(Player player) {
        return false;
    }

    public void clearContent() {
        if (!this.record.isEmpty()) {
            this.setItem(0, ItemStack.EMPTY);
        }
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void setChanged() {
    }
}

