/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client.sound;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SoundCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CacheMetadata.class, (Object)new MetadataSerializer()).create();
    private static final Path CACHE_FOLDER = Minecraft.getInstance().gameDirectory.toPath().resolve("etched-sounds");
    private static final ReentrantLock DOWNLOAD_LOCK = new ReentrantLock();
    private static final ReentrantLock METADATA_LOCK = new ReentrantLock();
    private static final ReentrantLock IO_LOCK = new ReentrantLock();
    private static final Type CACHE_METADATA_TYPE = new TypeToken<Map<String, CacheMetadata>>(){}.getType();
    private static final Path CACHE_METADATA_LOCATION = CACHE_FOLDER.resolve("cache.json");
    private static final int METADATA_WRITE_TIME = 5000;
    private static volatile Map<String, CacheMetadata> CACHE_METADATA = new HashMap<String, CacheMetadata>();
    private static volatile long nextWriteTime = Long.MAX_VALUE;
    private static final Cache<String, CompletableFuture<AudioSource>> SOURCE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static Map<String, Path> files = new ConcurrentHashMap<String, Path>();

    private SoundCache() {
    }

    private static synchronized void writeMetadata() {
        LOGGER.debug("Writing cache metadata to file.");
        try {
            METADATA_LOCK.lock();
            CACHE_METADATA.keySet().removeIf(name -> !Files.exists(CACHE_FOLDER.resolve((String)name), new LinkOption[0]));
        }
        finally {
            METADATA_LOCK.unlock();
        }
        try (FileOutputStream os = new FileOutputStream(CACHE_METADATA_LOCATION.toFile());){
            if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
            }
            IOUtils.write((String)GSON.toJson(CACHE_METADATA), (OutputStream)os, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write cache metadata", (Throwable)e);
        }
    }

    private static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        SOURCE_CACHE.invalidateAll();
    }

    private static void onClientTickPost(ClientTickEvent.Post event) {
        if (nextWriteTime == Long.MAX_VALUE) {
            return;
        }
        if (System.currentTimeMillis() - nextWriteTime > 0L) {
            nextWriteTime = Long.MAX_VALUE;
            Util.ioPool().execute(SoundCache::writeMetadata);
        }
    }

    public static CompletableFuture<AudioSource> getAudioStream(String url, @Nullable DownloadProgressListener listener, AudioSource.AudioFileType type) {
        try {
            return (CompletableFuture)SOURCE_CACHE.get((Object)url, () -> {
                try {
                    DOWNLOAD_LOCK.lock();
                    CompletionStage future = SoundSourceManager.getAudioSource(url, listener, Minecraft.getInstance().getProxy(), type).handle((source, e) -> {
                        if (e != null) {
                            if (listener != null) {
                                listener.onFail();
                            }
                            throw new CompletionException((Throwable)e);
                        }
                        return source;
                    });
                    SOURCE_CACHE.put((Object)url, (Object)future);
                    CompletionStage completionStage = future;
                    return completionStage;
                }
                finally {
                    DOWNLOAD_LOCK.unlock();
                }
            });
        }
        catch (Exception e) {
            if (listener != null) {
                listener.onFail();
            }
            throw new CompletionException("Failed to load audio into cache", e);
        }
    }

    @Nullable
    public static CacheMetadata getMetadata(String url) {
        return CACHE_METADATA.get(DigestUtils.md5Hex((String)url));
    }

    public static void updateCacheMetadata(String url, @Nullable CacheMetadata metadata) {
        try {
            METADATA_LOCK.lock();
            String key = DigestUtils.md5Hex((String)url);
            if (metadata != null) {
                CACHE_METADATA.put(key, metadata);
            } else {
                CACHE_METADATA.remove(key);
            }
            nextWriteTime = System.currentTimeMillis() + 5000L;
        }
        finally {
            METADATA_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCache(Path soundFile, String url, InputStream stream, CacheMetadata metadata) throws IOException {
        try {
            IO_LOCK.lock();
            if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
            }
            Files.copy(stream, soundFile, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            IO_LOCK.unlock();
        }
        SoundCache.updateCacheMetadata(url, metadata);
    }

    public static Path resolveFilePath(String url, boolean temporary) throws IOException {
        String key = DigestUtils.md5Hex((String)url);
        if (temporary) {
            if (files == null) {
                throw new IllegalStateException("Shutdown in progress");
            }
            if (!files.containsKey(key)) {
                files.put(key, Files.createTempFile(key, null, new FileAttribute[0]));
            }
            return files.get(key);
        }
        if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
            Files.createDirectories(CACHE_FOLDER, new FileAttribute[0]);
        }
        return CACHE_FOLDER.resolve(key);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Class<SoundCache> clazz = SoundCache.class;
            synchronized (SoundCache.class) {
                Map<String, Path> theFiles = files;
                files = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                theFiles.keySet().forEach(CACHE_METADATA::remove);
                ArrayList<Path> toBeDeleted = new ArrayList<Path>(theFiles.values());
                theFiles.clear();
                Collections.reverse(toBeDeleted);
                for (Path filename : toBeDeleted) {
                    try {
                        Files.deleteIfExists(filename);
                    }
                    catch (Exception exception) {}
                }
                SoundCache.writeMetadata();
                return;
            }
        }));
        if (Files.exists(CACHE_METADATA_LOCATION, new LinkOption[0])) {
            LOGGER.debug("Reading cache metadata from file.");
            try (InputStreamReader reader = new InputStreamReader(new FileInputStream(CACHE_METADATA_LOCATION.toFile()));){
                CACHE_METADATA = (Map)GSON.fromJson((Reader)reader, CACHE_METADATA_TYPE);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load cache metadata", (Throwable)e);
            }
        }
        NeoForge.EVENT_BUS.addListener(SoundCache::onClientDisconnect);
        NeoForge.EVENT_BUS.addListener(SoundCache::onClientTickPost);
    }

    public record CacheMetadata(long expiration, boolean noCache, boolean staleIfError) {
        public boolean isFresh() {
            return this.expiration - System.currentTimeMillis() / 1000L > 0L;
        }
    }

    private static class MetadataSerializer
    implements JsonDeserializer<CacheMetadata>,
    JsonSerializer<CacheMetadata> {
        private MetadataSerializer() {
        }

        public CacheMetadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject object = json.getAsJsonObject();
                long expiration = object.get("expiration").getAsLong();
                boolean noCache = object.get("noCache").getAsBoolean();
                boolean staleIfError = object.get("staleIfError").getAsBoolean();
                return new CacheMetadata(expiration, noCache, staleIfError);
            }
            return new CacheMetadata(json.getAsLong(), false, false);
        }

        public JsonElement serialize(CacheMetadata src, Type typeOfSrc, JsonSerializationContext context) {
            if (!src.noCache && !src.staleIfError) {
                return new JsonPrimitive((Number)src.expiration);
            }
            JsonObject json = new JsonObject();
            json.addProperty("expiration", (Number)src.expiration);
            if (src.noCache) {
                json.addProperty("noCache", Boolean.valueOf(true));
            }
            if (src.staleIfError) {
                json.addProperty("staleIfError", Boolean.valueOf(true));
            }
            return json;
        }
    }
}

