/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.record;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public record TrackData(String url, String artist, Component title) {
    public static final TrackData EMPTY = new TrackData(null, "Unknown", (Component)Component.literal((String)"Custom Music"));
    public static final Codec<TrackData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("Url").forGetter(TrackData::url), (App)Codec.STRING.optionalFieldOf("Author", (Object)EMPTY.artist()).forGetter(TrackData::artist), (App)ComponentSerialization.CODEC.optionalFieldOf("Title", (Object)EMPTY.title()).forGetter(TrackData::title)).apply((Applicative)instance, TrackData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TrackData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, TrackData::url, (StreamCodec)ByteBufCodecs.STRING_UTF8, TrackData::artist, (StreamCodec)ComponentSerialization.STREAM_CODEC, TrackData::title, TrackData::new);
    private static final Pattern RESOURCE_LOCATION_PATTERN = Pattern.compile("[a-z0-9_.-]+");

    public static boolean isValidURL(@Nullable String url) {
        if (url == null) {
            return false;
        }
        if (TrackData.isLocalSound(url)) {
            return true;
        }
        try {
            String scheme = new URI(url).getScheme();
            return "http".equals(scheme) || "https".equals(scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isLocalSound(@Nullable String url) {
        if (url == null) {
            return false;
        }
        String[] parts = url.split(":");
        if (parts.length > 2) {
            return false;
        }
        for (String part : parts) {
            if (RESOURCE_LOCATION_PATTERN.matcher(part).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return TrackData.isValidURL(this.url);
    }

    public TrackData withUrl(String url) {
        return new TrackData(url, this.artist, this.title);
    }

    public TrackData withArtist(String artist) {
        return new TrackData(this.url, artist, this.title);
    }

    public TrackData withTitle(String title) {
        return new TrackData(this.url, this.artist, (Component)Component.literal((String)title));
    }

    public TrackData withTitle(Component title) {
        return new TrackData(this.url, this.artist, title);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"sound_source.etched.info", (Object[])new Object[]{this.artist, this.title});
    }
}

