/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.util.StringRepresentable;
import net.vercte.extendedwrenches.ExtendedWrenchesData;
import net.vercte.extendedwrenches.wrench.WrenchMaterial;
import net.vercte.extendedwrenches.wrench.WrenchPart;
import org.jetbrains.annotations.Nullable;

public record WrenchMaterialComponent(Map<WrenchPart, Holder<WrenchMaterial>> parts) {
    public static final Codec<WrenchMaterialComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)StringRepresentable.fromEnum(WrenchPart::values), (Codec)RegistryFixedCodec.create(ExtendedWrenchesData.WRENCH_MATERIAL)).fieldOf("parts").forGetter(WrenchMaterialComponent::parts)).apply((Applicative)instance, WrenchMaterialComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WrenchMaterialComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.idMapper(WrenchPart.BY_ID, WrenchPart::getId), (StreamCodec)ByteBufCodecs.holderRegistry(ExtendedWrenchesData.WRENCH_MATERIAL), (int)3), WrenchMaterialComponent::parts, WrenchMaterialComponent::new);

    public static WrenchMaterialComponent empty() {
        return new WrenchMaterialComponent(new HashMap<WrenchPart, Holder<WrenchMaterial>>());
    }

    public boolean partPresent(WrenchPart part) {
        return this.parts.containsKey((Object)part);
    }

    @Nullable
    public Holder<WrenchMaterial> getMaterialHolder(WrenchPart part) {
        return this.parts.get((Object)part);
    }

    public WrenchMaterialComponent withChangedMaterial(WrenchPart part, Holder<WrenchMaterial> material) {
        WrenchMaterialComponent newComponent = new WrenchMaterialComponent(new HashMap<WrenchPart, Holder<WrenchMaterial>>(this.parts));
        newComponent.parts.put(part, material);
        return newComponent;
    }
}

