/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.google.common.collect.Lists;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.vercte.extendedwrenches.ExtendedWrenchesRecipeSerializers;
import net.vercte.extendedwrenches.wrench.ExtendedWrenchItem;
import org.jetbrains.annotations.NotNull;

public class WrenchDyeRecipe
extends CustomRecipe {
    public WrenchDyeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, @NotNull Level level) {
        ItemStack wrench = ItemStack.EMPTY;
        ArrayList dyes = Lists.newArrayList();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof WrenchItem) {
                if (!wrench.isEmpty()) {
                    return false;
                }
                wrench = stack;
                continue;
            }
            if (!(stack.getItem() instanceof DyeItem)) {
                return false;
            }
            dyes.add(stack);
        }
        return !wrench.isEmpty() && !dyes.isEmpty();
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, @NotNull HolderLookup.Provider registries) {
        ArrayList dyes = Lists.newArrayList();
        ItemStack wrench = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof WrenchItem) {
                if (!wrench.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                wrench = ExtendedWrenchItem.convertWrench(stack);
                continue;
            }
            Item item = stack.getItem();
            if (!(item instanceof DyeItem)) {
                return ItemStack.EMPTY;
            }
            DyeItem dyeitem = (DyeItem)item;
            dyes.add(dyeitem);
        }
        return !wrench.isEmpty() && !dyes.isEmpty() ? DyedItemColor.applyDyes((ItemStack)wrench, (List)dyes) : ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ExtendedWrenchesRecipeSerializers.WRENCH_DYE.get();
    }
}

