/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.holycubebackport.blocks;

import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface SegmentableBlock {
    public static final int MIN_SEGMENT = 1;
    public static final int MAX_SEGMENT = 4;
    public static final IntegerProperty AMOUNT = IntegerProperty.create((String)"segment_amount", (int)1, (int)4);
    public static final BiFunction<Direction, Integer, VoxelShape> SHAPE_BY_PROPERTIES = Util.memoize((p_296142_, p_294775_) -> {
        VoxelShape[] avoxelshape = new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)16.0)};
        VoxelShape voxelshape = Shapes.empty();
        for (int i = 0; i < p_294775_; ++i) {
            int j = Math.floorMod(i - p_296142_.get2DDataValue(), 4);
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)avoxelshape[j]);
        }
        return voxelshape.singleEncompassing();
    });

    default public IntegerProperty getSegmentAmountProperty() {
        return AMOUNT;
    }

    default public double getShapeHeight() {
        return 1.0;
    }

    default public boolean canBeReplaced(BlockState p_394221_, BlockPlaceContext p_394124_, IntegerProperty p_394071_) {
        return !p_394124_.isSecondaryUseActive() && p_394124_.getItemInHand().is(p_394221_.getBlock().asItem()) && (Integer)p_394221_.getValue((Property)p_394071_) < 4;
    }

    default public BlockState getStateForPlacement(BlockPlaceContext p_394035_, Block p_393593_, IntegerProperty p_394488_, EnumProperty<Direction> p_393563_) {
        BlockState blockstate = p_394035_.getLevel().getBlockState(p_394035_.getClickedPos());
        return blockstate.is(p_393593_) ? (BlockState)blockstate.setValue((Property)p_394488_, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.getValue((Property)p_394488_) + 1))) : (BlockState)p_393593_.defaultBlockState().setValue(p_393563_, (Comparable)p_394035_.getHorizontalDirection().getOpposite());
    }
}

