/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.holycubebackport.blocks;

import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PathStairBlock
extends StairBlock {
    protected static final VoxelShape TOP_AABB = Block.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape OCTET_NNN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)7.0, (double)8.0);
    protected static final VoxelShape OCTET_NNP = Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)7.0, (double)16.0);
    protected static final VoxelShape OCTET_NPN = Block.box((double)0.0, (double)7.0, (double)0.0, (double)8.0, (double)15.0, (double)8.0);
    protected static final VoxelShape OCTET_NPP = Block.box((double)0.0, (double)7.0, (double)8.0, (double)8.0, (double)15.0, (double)16.0);
    protected static final VoxelShape OCTET_PNN = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)8.0);
    protected static final VoxelShape OCTET_PNP = Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape OCTET_PPN = Block.box((double)8.0, (double)7.0, (double)0.0, (double)16.0, (double)15.0, (double)8.0);
    protected static final VoxelShape OCTET_PPP = Block.box((double)8.0, (double)7.0, (double)8.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape[] TOP_SHAPES = PathStairBlock.makeShapes(TOP_AABB, OCTET_NNN, OCTET_PNN, OCTET_NNP, OCTET_PNP);
    protected static final VoxelShape[] BOTTOM_SHAPES = PathStairBlock.makeShapes(BOTTOM_AABB, OCTET_NPN, OCTET_PPN, OCTET_NPP, OCTET_PPP);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes(VoxelShape p_56934_, VoxelShape p_56935_, VoxelShape p_56936_, VoxelShape p_56937_, VoxelShape p_56938_) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_56945_ -> PathStairBlock.makeStairShape(p_56945_, p_56934_, p_56935_, p_56936_, p_56937_, p_56938_)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int p_56865_, VoxelShape p_56866_, VoxelShape p_56867_, VoxelShape p_56868_, VoxelShape p_56869_, VoxelShape p_56870_) {
        VoxelShape voxelshape = p_56866_;
        if ((p_56865_ & 1) != 0) {
            voxelshape = Shapes.or((VoxelShape)p_56866_, (VoxelShape)p_56867_);
        }
        if ((p_56865_ & 2) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)p_56868_);
        }
        if ((p_56865_ & 4) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)p_56869_);
        }
        if ((p_56865_ & 8) != 0) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)p_56870_);
        }
        return voxelshape;
    }

    protected VoxelShape getShape(BlockState p_56956_, BlockGetter p_56957_, BlockPos p_56958_, CollisionContext p_56959_) {
        return (p_56956_.getValue((Property)HALF) == Half.TOP ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(p_56956_)]];
    }

    private int getShapeIndex(BlockState p_56983_) {
        return ((StairsShape)p_56983_.getValue((Property)SHAPE)).ordinal() * 4 + ((Direction)p_56983_.getValue((Property)FACING)).get2DDataValue();
    }

    public PathStairBlock(BlockState p_56862_, BlockBehaviour.Properties p_56863_) {
        super(p_56862_, p_56863_);
    }
}

