/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.holycubebackport.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import fr.iglee42.holycubebackport.Boxes;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultifaceBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<MultifaceBlock> CODEC = MultifaceBlock.simpleCodec(MultifaceBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;
    protected static final Direction[] DIRECTIONS = Direction.values();
    private final Function<BlockState, VoxelShape> shapes;
    private final boolean canRotate;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    public MultifaceBlock(BlockBehaviour.Properties p_153822_) {
        super(p_153822_);
        this.registerDefaultState(MultifaceBlock.getDefaultMultifaceState((StateDefinition<Block, BlockState>)this.stateDefinition));
        this.shapes = this.makeShapes();
        this.canRotate = Direction.Plane.HORIZONTAL.stream().allMatch(this::isFaceSupported);
        this.canMirrorX = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        this.canMirrorZ = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        Map<Direction, VoxelShape> map = Boxes.rotateAll(Boxes.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(p_393369_ -> {
            VoxelShape voxelshape = Shapes.empty();
            for (Direction direction : DIRECTIONS) {
                if (!MultifaceBlock.hasFace(p_393369_, direction)) continue;
                voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)((VoxelShape)map.get(direction)));
            }
            return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
        }, new Property[]{WATERLOGGED});
    }

    protected Function<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> p_152459_, Property<?> ... p_394264_) {
        Map<Property, Object> map = Arrays.stream(p_394264_).collect(Collectors.toMap(p_393321_ -> p_393321_, p_393320_ -> p_393320_.getPossibleValues().stream().toList().getFirst()));
        ImmutableMap immutablemap = (ImmutableMap)this.stateDefinition.getPossibleStates().stream().filter(p_393327_ -> map.entrySet().stream().allMatch(p_393329_ -> p_393327_.getValue((Property)p_393329_.getKey()) == p_393329_.getValue())).collect(ImmutableMap.toImmutableMap(Function.identity(), p_152459_));
        return p_393324_ -> {
            for (Map.Entry entry : map.entrySet()) {
                p_393324_ = MultifaceBlock.setValueHelper(p_393324_, (Property)entry.getKey(), entry.getValue());
            }
            return (VoxelShape)immutablemap.get(p_393324_);
        };
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S p_394311_, Property<T> p_394352_, Object p_394525_) {
        return (S)((StateHolder)p_394311_.setValue(p_394352_, (Comparable)p_394525_));
    }

    public static Set<Direction> availableFaces(BlockState p_221585_) {
        if (!(p_221585_.getBlock() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        for (Direction direction : Direction.values()) {
            if (!MultifaceBlock.hasFace(p_221585_, direction)) continue;
            set.add(direction);
        }
        return set;
    }

    public static Set<Direction> unpack(byte p_221570_) {
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        for (Direction direction : Direction.values()) {
            if ((p_221570_ & (byte)(1 << direction.ordinal())) <= 0) continue;
            set.add(direction);
        }
        return set;
    }

    public static byte pack(Collection<Direction> p_221577_) {
        byte b0 = 0;
        for (Direction direction : p_221577_) {
            b0 = (byte)(b0 | 1 << direction.ordinal());
        }
        return b0;
    }

    protected boolean isFaceSupported(Direction p_153921_) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_153917_) {
        for (Direction direction : DIRECTIONS) {
            if (!this.isFaceSupported(direction)) continue;
            p_153917_.add(new Property[]{MultifaceBlock.getFaceProperty(direction)});
        }
        p_153917_.add(new Property[]{WATERLOGGED});
    }

    protected BlockState updateShape(BlockState p_60541_, Direction p_60542_, BlockState p_60543_, LevelAccessor p_60544_, BlockPos p_60545_, BlockPos p_60546_) {
        if (((Boolean)p_60541_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_60544_.scheduleTick(p_60545_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_60544_));
        }
        if (!MultifaceBlock.hasAnyFace(p_60541_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return MultifaceBlock.hasFace(p_60541_, p_60542_) && !MultifaceBlock.canAttachTo((BlockGetter)p_60544_, p_60542_, p_60546_, p_60543_) ? MultifaceBlock.removeFace(p_60541_, MultifaceBlock.getFaceProperty(p_60542_)) : p_60541_;
    }

    protected FluidState getFluidState(BlockState p_389529_) {
        return (Boolean)p_389529_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_389529_);
    }

    protected VoxelShape getShape(BlockState p_153851_, BlockGetter p_153852_, BlockPos p_153853_, CollisionContext p_153854_) {
        return this.shapes.apply(p_153851_);
    }

    protected boolean canSurvive(BlockState p_153888_, LevelReader p_153889_, BlockPos p_153890_) {
        boolean flag = false;
        for (Direction direction : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(p_153888_, direction)) continue;
            if (!MultifaceBlock.canAttachTo((BlockGetter)p_153889_, p_153890_, direction)) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    protected boolean canBeReplaced(BlockState p_153848_, BlockPlaceContext p_153849_) {
        return !p_153849_.getItemInHand().is(this.asItem()) || MultifaceBlock.hasAnyVacantFace(p_153848_);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_153824_) {
        Level level = p_153824_.getLevel();
        BlockPos blockpos = p_153824_.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        return Arrays.stream(p_153824_.getNearestLookingDirections()).map(p_153865_ -> this.getStateForPlacement(blockstate, (BlockGetter)level, blockpos, (Direction)p_153865_)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean isValidStateForPlacement(BlockGetter p_221572_, BlockState p_221573_, BlockPos p_221574_, Direction p_221575_) {
        if (!(!this.isFaceSupported(p_221575_) || p_221573_.is((Block)this) && MultifaceBlock.hasFace(p_221573_, p_221575_))) {
            BlockPos blockpos = p_221574_.relative(p_221575_);
            return MultifaceBlock.canAttachTo(p_221572_, p_221575_, blockpos, p_221572_.getBlockState(blockpos));
        }
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockState p_153941_, BlockGetter p_153942_, BlockPos p_153943_, Direction p_153944_) {
        if (!this.isValidStateForPlacement(p_153942_, p_153941_, p_153943_, p_153944_)) {
            return null;
        }
        BlockState blockstate = p_153941_.is((Block)this) ? p_153941_ : (p_153941_.getFluidState().isSourceOfType((Fluid)Fluids.WATER) ? (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : this.defaultBlockState());
        return (BlockState)blockstate.setValue((Property)MultifaceBlock.getFaceProperty(p_153944_), (Comparable)Boolean.valueOf(true));
    }

    protected BlockState rotate(BlockState p_153895_, Rotation p_153896_) {
        return !this.canRotate ? p_153895_ : this.mapDirections(p_153895_, arg_0 -> ((Rotation)p_153896_).rotate(arg_0));
    }

    protected BlockState mirror(BlockState p_153892_, Mirror p_153893_) {
        if (p_153893_ == Mirror.FRONT_BACK && !this.canMirrorX) {
            return p_153892_;
        }
        return p_153893_ == Mirror.LEFT_RIGHT && !this.canMirrorZ ? p_153892_ : this.mapDirections(p_153892_, arg_0 -> ((Mirror)p_153893_).mirror(arg_0));
    }

    private BlockState mapDirections(BlockState p_153911_, Function<Direction, Direction> p_153912_) {
        BlockState blockstate = p_153911_;
        for (Direction direction : DIRECTIONS) {
            if (!this.isFaceSupported(direction)) continue;
            blockstate = (BlockState)blockstate.setValue((Property)MultifaceBlock.getFaceProperty(p_153912_.apply(direction)), (Comparable)((Boolean)p_153911_.getValue((Property)MultifaceBlock.getFaceProperty(direction))));
        }
        return blockstate;
    }

    public static boolean hasFace(BlockState p_153901_, Direction p_153902_) {
        BooleanProperty booleanproperty = MultifaceBlock.getFaceProperty(p_153902_);
        return p_153901_.getOptionalValue((Property)booleanproperty).orElse(false);
    }

    public static boolean canAttachTo(BlockGetter p_383192_, BlockPos p_383013_, Direction p_383221_) {
        BlockPos blockpos = p_383013_.relative(p_383221_);
        BlockState blockstate = p_383192_.getBlockState(blockpos);
        return MultifaceBlock.canAttachTo(p_383192_, p_383221_, blockpos, blockstate);
    }

    public static boolean canAttachTo(BlockGetter p_153830_, Direction p_153831_, BlockPos p_153832_, BlockState p_153833_) {
        return Block.isFaceFull((VoxelShape)p_153833_.getBlockSupportShape(p_153830_, p_153832_), (Direction)p_153831_.getOpposite()) || Block.isFaceFull((VoxelShape)p_153833_.getCollisionShape(p_153830_, p_153832_), (Direction)p_153831_.getOpposite());
    }

    private static BlockState removeFace(BlockState p_153898_, BooleanProperty p_153899_) {
        BlockState blockstate = (BlockState)p_153898_.setValue((Property)p_153899_, (Comparable)Boolean.valueOf(false));
        return MultifaceBlock.hasAnyFace(blockstate) ? blockstate : Blocks.AIR.defaultBlockState();
    }

    public static BooleanProperty getFaceProperty(Direction p_153934_) {
        return PROPERTY_BY_DIRECTION.get(p_153934_);
    }

    private static BlockState getDefaultMultifaceState(StateDefinition<Block, BlockState> p_153919_) {
        BlockState blockstate = (BlockState)((BlockState)p_153919_.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            blockstate = (BlockState)blockstate.trySetValue((Property)booleanproperty, (Comparable)Boolean.valueOf(false));
        }
        return blockstate;
    }

    protected static boolean hasAnyFace(BlockState p_153961_) {
        for (Direction direction : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(p_153961_, direction)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyVacantFace(BlockState p_153963_) {
        for (Direction direction : DIRECTIONS) {
            if (MultifaceBlock.hasFace(p_153963_, direction)) continue;
            return true;
        }
        return false;
    }
}

