/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.holycubebackport;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import fr.iglee42.holycubebackport.HolyBackBlocks;
import fr.iglee42.holycubebackport.HolyBackSounds;
import fr.iglee42.holycubebackport.PaleMossDecorator;
import fr.iglee42.holycubebackport.PlaceOnGroundDecorator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="holycubebackport")
public class HolycubeBackport {
    public static final String MODID = "holycubebackport";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALE_OAK_BONEMEAL = FeatureUtils.createKey((String)"pale_oak_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALE_MOSS_PATCH = FeatureUtils.createKey((String)"pale_moss_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALE_MOSS_PATCH_BONEMEAL = FeatureUtils.createKey((String)"pale_moss_patch_bonemeal");
    public static final TagKey<Block> PALE_OAK_LOGS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pale_oak_logs"));
    public static final TagKey<Block> DRY_VEGETATION_MAY_PLACE_ON = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"dry_vegetation_may_place_on"));
    public static final TagKey<Block> PLAYS_AMBIENT_DESERT_BLOCK_SOUNDS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"plays_ambient_desert_block_sounds"));
    public static final TreeDecoratorType<PaleMossDecorator> PALE_MOSS_DECORATOR = TreeDecoratorType.register((String)"pale_moss", PaleMossDecorator.CODEC);
    public static final TreeDecoratorType<PlaceOnGroundDecorator> PLACE_ON_GROUND = TreeDecoratorType.register((String)"place_on_ground", PlaceOnGroundDecorator.CODEC);
    public static final BlockSetType PALE_OAK_SET = BlockSetType.register((BlockSetType)new BlockSetType("pale_oak"));
    public static final WoodType PALE_OAK_TYPE = WoodType.register((WoodType)new WoodType("pale_oak", PALE_OAK_SET));
    public static final TreeGrower PALE_OAK = new TreeGrower("pale_oak", Optional.of(PALE_OAK_BONEMEAL), Optional.empty(), Optional.empty());
    public static Boat.Type PALE_OAK_BOAT;

    public HolycubeBackport(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        HolyBackSounds.SOUNDS.register(modEventBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::clientSetup);
        }
        modEventBus.addListener(this::registerEvent);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.PALE_OAK_LEAVES, (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.CLOSED_EYEBLOSSOM, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.OPEN_EYEBLOSSOM, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.PALE_OAK_SAPLING, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.PALE_OAK_TRAPDOOR, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.PALE_MOSS_CARPET, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.PALE_HANGING_MOSS, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.POTTED_PALE_OAK_SAPLING, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.POTTED_CLOSED_EYEBLOSSOM, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.POTTED_OPEN_EYEBLOSSOM, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.PALE_OAK_DOOR, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.FIREFLY_BUSH, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.BUSH, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.GRASS_SLAB, (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.GRASS_STAIRS, (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.SHORT_DRY_GRASS, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.TALL_DRY_GRASS, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.LEAF_LITTER, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.CACTUS_FLOWER, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.RESIN_CLUMP, (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)HolyBackBlocks.WILDFLOWERS, (RenderType)RenderType.cutout());
        Minecraft.getInstance().getBlockColors().register((p_276237_, p_276238_, p_276239_, p_276240_) -> p_276238_ != null && p_276239_ != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)p_276238_, (BlockPos)p_276239_) : GrassColor.getDefaultColor(), new Block[]{HolyBackBlocks.GRASS_SLAB, HolyBackBlocks.GRASS_STAIRS, HolyBackBlocks.BUSH});
        Minecraft.getInstance().getItemColors().register((p_92687_, p_92688_) -> {
            BlockState blockstate = ((BlockItem)p_92687_.getItem()).getBlock().defaultBlockState();
            return Minecraft.getInstance().getBlockColors().getColor(blockstate, null, null, p_92688_);
        }, new ItemLike[]{HolyBackBlocks.GRASS_SLAB, HolyBackBlocks.GRASS_STAIRS, HolyBackBlocks.BUSH});
        Minecraft.getInstance().getBlockColors().register((p_276241_, p_276242_, p_276243_, p_276244_) -> {
            if (p_276244_ != 0) {
                return p_276242_ != null && p_276243_ != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)p_276242_, (BlockPos)p_276243_) : GrassColor.getDefaultColor();
            }
            return -1;
        }, new Block[]{HolyBackBlocks.WILDFLOWERS});
    }

    private void registerEvent(RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.ITEM)) {
            return;
        }
        AxeItem.STRIPPABLES = Maps.newHashMap((Map)AxeItem.STRIPPABLES);
        AxeItem.STRIPPABLES.put(HolyBackBlocks.PALE_OAK_LOG, HolyBackBlocks.STRIPPED_PALE_OAK_LOG);
        AxeItem.STRIPPABLES.put(HolyBackBlocks.PALE_OAK_WOOD, HolyBackBlocks.STRIPPED_PALE_OAK_WOOD);
    }
}

