/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.network;

import net.mcreator.createstuffadditions.CreateSaMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CreateSaModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"create_sa");

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CreateSaMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"create_sa", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "create_sa_mapvars";
        public double db_y = 0.0;
        public double db_z = 0.0;
        public double db_x = 0.0;
        public boolean CsaFlying = false;
        public double brassJetpackMaxHeight = 28.0;
        public double andesiteJetpackMaxHeight = 18.0;
        public double copperJetpackMaxHeight = 18.0;
        public double netheriteJetpackMaxHeight = 28.0;
        public boolean enableAboveCloudEnchant = false;
        public double brassJetpackSpeed = 0.06;
        public double andesiteJetpackSpeed = 0.08;
        public double copperJetpackSpeed = 0.02;
        public double netheriteJetpackSpeed = 0.08;
        public double grapplinWhiskSpeed = 0.2;
        public double gadgetCapacity = 1600.0;
        public double smallTankCapacity = 800.0;
        public double mediumTankCapacity = 1600.0;
        public double largeTankCapacity = 3200.0;
        public boolean enableDiggingEnchant = true;
        public boolean enableImpactEnchant = true;
        public boolean enableGravityGunEnchant = true;
        public boolean enableHellfireEnchant = true;
        public boolean enableDrillDroneModule = true;
        public boolean enableFanDroneModule = true;
        public boolean enableMagnetDroneModule = true;
        public boolean enableVaultDroneModule = true;
        public boolean MagnetModuleBlockLimitation = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.db_y = nbt.getDouble("db_y");
            this.db_z = nbt.getDouble("db_z");
            this.db_x = nbt.getDouble("db_x");
            this.CsaFlying = nbt.getBoolean("CsaFlying");
            this.brassJetpackMaxHeight = nbt.getDouble("brassJetpackMaxHeight");
            this.andesiteJetpackMaxHeight = nbt.getDouble("andesiteJetpackMaxHeight");
            this.copperJetpackMaxHeight = nbt.getDouble("copperJetpackMaxHeight");
            this.netheriteJetpackMaxHeight = nbt.getDouble("netheriteJetpackMaxHeight");
            this.enableAboveCloudEnchant = nbt.getBoolean("enableAboveCloudEnchant");
            this.brassJetpackSpeed = nbt.getDouble("brassJetpackSpeed");
            this.andesiteJetpackSpeed = nbt.getDouble("andesiteJetpackSpeed");
            this.copperJetpackSpeed = nbt.getDouble("copperJetpackSpeed");
            this.netheriteJetpackSpeed = nbt.getDouble("netheriteJetpackSpeed");
            this.grapplinWhiskSpeed = nbt.getDouble("grapplinWhiskSpeed");
            this.gadgetCapacity = nbt.getDouble("gadgetCapacity");
            this.smallTankCapacity = nbt.getDouble("smallTankCapacity");
            this.mediumTankCapacity = nbt.getDouble("mediumTankCapacity");
            this.largeTankCapacity = nbt.getDouble("largeTankCapacity");
            this.enableDiggingEnchant = nbt.getBoolean("enableDiggingEnchant");
            this.enableImpactEnchant = nbt.getBoolean("enableImpactEnchant");
            this.enableGravityGunEnchant = nbt.getBoolean("enableGravityGunEnchant");
            this.enableHellfireEnchant = nbt.getBoolean("enableHellfireEnchant");
            this.enableDrillDroneModule = nbt.getBoolean("enableDrillDroneModule");
            this.enableFanDroneModule = nbt.getBoolean("enableFanDroneModule");
            this.enableMagnetDroneModule = nbt.getBoolean("enableMagnetDroneModule");
            this.enableVaultDroneModule = nbt.getBoolean("enableVaultDroneModule");
            this.MagnetModuleBlockLimitation = nbt.getBoolean("MagnetModuleBlockLimitation");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("db_y", this.db_y);
            nbt.putDouble("db_z", this.db_z);
            nbt.putDouble("db_x", this.db_x);
            nbt.putBoolean("CsaFlying", this.CsaFlying);
            nbt.putDouble("brassJetpackMaxHeight", this.brassJetpackMaxHeight);
            nbt.putDouble("andesiteJetpackMaxHeight", this.andesiteJetpackMaxHeight);
            nbt.putDouble("copperJetpackMaxHeight", this.copperJetpackMaxHeight);
            nbt.putDouble("netheriteJetpackMaxHeight", this.netheriteJetpackMaxHeight);
            nbt.putBoolean("enableAboveCloudEnchant", this.enableAboveCloudEnchant);
            nbt.putDouble("brassJetpackSpeed", this.brassJetpackSpeed);
            nbt.putDouble("andesiteJetpackSpeed", this.andesiteJetpackSpeed);
            nbt.putDouble("copperJetpackSpeed", this.copperJetpackSpeed);
            nbt.putDouble("netheriteJetpackSpeed", this.netheriteJetpackSpeed);
            nbt.putDouble("grapplinWhiskSpeed", this.grapplinWhiskSpeed);
            nbt.putDouble("gadgetCapacity", this.gadgetCapacity);
            nbt.putDouble("smallTankCapacity", this.smallTankCapacity);
            nbt.putDouble("mediumTankCapacity", this.mediumTankCapacity);
            nbt.putDouble("largeTankCapacity", this.largeTankCapacity);
            nbt.putBoolean("enableDiggingEnchant", this.enableDiggingEnchant);
            nbt.putBoolean("enableImpactEnchant", this.enableImpactEnchant);
            nbt.putBoolean("enableGravityGunEnchant", this.enableGravityGunEnchant);
            nbt.putBoolean("enableHellfireEnchant", this.enableHellfireEnchant);
            nbt.putBoolean("enableDrillDroneModule", this.enableDrillDroneModule);
            nbt.putBoolean("enableFanDroneModule", this.enableFanDroneModule);
            nbt.putBoolean("enableMagnetDroneModule", this.enableMagnetDroneModule);
            nbt.putBoolean("enableVaultDroneModule", this.enableVaultDroneModule);
            nbt.putBoolean("MagnetModuleBlockLimitation", this.MagnetModuleBlockLimitation);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "create_sa_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

