/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.client.renderer.jetpack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.mixin.accessor.EntityRenderDispatcherAccessor;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.mcreator.createstuffadditions.configuration.CreateSaConfigConfiguration;
import net.mcreator.createstuffadditions.init.CreateSaModBlocks;
import net.mcreator.createstuffadditions.init.CreateSaModItems;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class NetheriteJetpackArmorRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public NetheriteJetpackArmorRenderer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int light, LivingEntity entity, float yaw, float pitch, float pt, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        if (entity.getPose() == Pose.SLEEPING) {
            return;
        }
        ItemStack item = entity.getItemBySlot(EquipmentSlot.CHEST);
        if (item == null) {
            return;
        }
        if (item.getItem() != CreateSaModItems.NETHERITE_JETPACK_CHESTPLATE.get()) {
            return;
        }
        EntityModel entityModel = this.getParentModel();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel model = (HumanoidModel)entityModel;
        VertexConsumer vc = buffer.getBuffer(Sheets.cutoutBlockSheet());
        Vec3 mvVec = new Vec3(entity.xo - entity.getX(), 0.0, entity.zo - entity.getZ());
        Vec3 lookDir = new Vec3(entity.getViewVector(AnimationTickHolder.getPartialTicks()).normalize().x(), 0.0, entity.getViewVector(AnimationTickHolder.getPartialTicks()).normalize().z());
        float mov_angle = (float)(-new Vec3(lookDir.y() * mvVec.z() - mvVec.y() * lookDir.z(), lookDir.z() * mvVec.x() - mvVec.z() * lookDir.x(), lookDir.x() * mvVec.y() - mvVec.x() * lookDir.y()).y());
        float speed = -0.5f;
        float propeller_speed = 0.0f;
        if (((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") > 0.0 && ((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") > 0.0) {
            speed = -0.5f + (float)Math.round((((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + ((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater")) / (Double)CreateSaConfigConfiguration.GADGETCAPACITY.get() * -1.0) * 4.0f;
        }
        if (((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("isFlying") && ((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") > 0.0 && ((CustomData)item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagWater") > 0.0) {
            speed = 15.0f;
            propeller_speed = 20.0f;
        } else if (entity.onGround()) {
            mov_angle = 0.0f;
        }
        SuperByteBuffer cogs = CachedBuffers.block((BlockState)new Object(this){

            /*
             * Enabled aggressive block sorting
             */
            public BlockState with(BlockState _bs, String _property, int _newValue) {
                BlockState blockState;
                Property _prop = _bs.getBlock().getStateDefinition().getProperty(_property);
                if (_prop instanceof IntegerProperty) {
                    IntegerProperty _ip = (IntegerProperty)_prop;
                    if (_prop.getPossibleValues().contains(_newValue)) {
                        blockState = (BlockState)_bs.setValue((Property)_ip, (Comparable)Integer.valueOf(_newValue));
                        return blockState;
                    }
                }
                blockState = _bs;
                return blockState;
            }
        }.with(((Block)CreateSaModBlocks.PROPELLER_RENDER_PROP.get()).defaultBlockState(), "blockstate", 5));
        ms.pushPose();
        model.body.translateAndRotate(ms);
        ms.translate(-0.5f, 0.625f, 1.0f);
        ms.scale(1.0f, -1.0f, -1.0f);
        cogs.translate(0.0f, -0.09375f, 0.8125f);
        cogs.rotateX(-1.5707964f);
        ((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateY((float)Math.PI)).uncenter();
        ((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateY(AngleHelper.rad((double)(mov_angle * 50.0f)))).uncenter();
        cogs.disableDiffuse().light(light).renderInto(ms, vc);
        ms.popPose();
        cogs = CachedBuffers.block((BlockState)new Object(this){

            /*
             * Enabled aggressive block sorting
             */
            public BlockState with(BlockState _bs, String _property, int _newValue) {
                BlockState blockState;
                Property _prop = _bs.getBlock().getStateDefinition().getProperty(_property);
                if (_prop instanceof IntegerProperty) {
                    IntegerProperty _ip = (IntegerProperty)_prop;
                    if (_prop.getPossibleValues().contains(_newValue)) {
                        blockState = (BlockState)_bs.setValue((Property)_ip, (Comparable)Integer.valueOf(_newValue));
                        return blockState;
                    }
                }
                blockState = _bs;
                return blockState;
            }
        }.with(((Block)CreateSaModBlocks.PROPELLER_RENDER_PROP.get()).defaultBlockState(), "blockstate", 3));
        ms.pushPose();
        model.body.translateAndRotate(ms);
        ms.translate(-0.5f, 0.625f, 1.0f);
        ms.scale(1.0f, -1.0f, -1.0f);
        cogs.translate(0.0f, -0.09375f, 0.9375f);
        cogs.rotateX(-1.5707964f);
        ((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateY(AngleHelper.rad((double)(mov_angle * 50.0f)))).uncenter();
        ((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateY(AngleHelper.rad((double)(speed * AnimationTickHolder.getRenderTime((LevelAccessor)entity.level()) % 360.0f)))).uncenter();
        cogs.disableDiffuse().light(light).renderInto(ms, vc);
        ms.popPose();
        cogs = CachedBuffers.block((BlockState)new Object(this){

            /*
             * Enabled aggressive block sorting
             */
            public BlockState with(BlockState _bs, String _property, int _newValue) {
                BlockState blockState;
                Property _prop = _bs.getBlock().getStateDefinition().getProperty(_property);
                if (_prop instanceof IntegerProperty) {
                    IntegerProperty _ip = (IntegerProperty)_prop;
                    if (_prop.getPossibleValues().contains(_newValue)) {
                        blockState = (BlockState)_bs.setValue((Property)_ip, (Comparable)Integer.valueOf(_newValue));
                        return blockState;
                    }
                }
                blockState = _bs;
                return blockState;
            }
        }.with(((Block)CreateSaModBlocks.PROPELLER_RENDER_PROP.get()).defaultBlockState(), "blockstate", 6));
        ms.pushPose();
        model.body.translateAndRotate(ms);
        ms.translate(-0.5f, 0.625f, 1.0f);
        ms.scale(1.0f, -1.0f, -1.0f);
        cogs.translate(0.0f, -0.09375f, 1.04125f);
        cogs.rotateX(-1.5707964f);
        ((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateY((float)Math.PI)).uncenter();
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateY(AngleHelper.rad((double)(mov_angle * 50.0f)))).translate(-0.315625f, 0.0f, 0.0f)).uncenter();
        ((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateZ(AngleHelper.rad((double)(propeller_speed * AnimationTickHolder.getRenderTime((LevelAccessor)entity.level()) % 360.0f)))).uncenter();
        cogs.disableDiffuse().light(light).renderInto(ms, vc);
        ms.popPose();
        ms.pushPose();
        model.body.translateAndRotate(ms);
        ms.translate(-0.5f, 0.625f, 1.0f);
        ms.scale(1.0f, -1.0f, -1.0f);
        cogs.translate(0.0f, -0.09375f, 1.04125f);
        cogs.rotateX(-1.5707964f);
        ((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateY((float)Math.PI)).uncenter();
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateY(AngleHelper.rad((double)(mov_angle * 50.0f)))).translate(0.315625f, 0.0f, 0.0f)).uncenter();
        ((SuperByteBuffer)((SuperByteBuffer)cogs.center()).rotateZ(AngleHelper.rad((double)(-propeller_speed * AnimationTickHolder.getRenderTime((LevelAccessor)entity.level()) % 360.0f)))).uncenter();
        cogs.disableDiffuse().light(light).renderInto(ms, vc);
        ms.popPose();
    }

    public static void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            NetheriteJetpackArmorRenderer.registerOn(renderer);
        }
        for (EntityRenderer renderer : ((EntityRenderDispatcherAccessor)renderManager).create$getRenderers().values()) {
            NetheriteJetpackArmorRenderer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        if (!(livingRenderer.getModel() instanceof HumanoidModel)) {
            return;
        }
        NetheriteJetpackArmorRenderer layer = new NetheriteJetpackArmorRenderer(livingRenderer);
        livingRenderer.addLayer(layer);
    }
}

