/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.datagen.neoforge;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import rbasamoyai.escalated.CreateEscalated;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.EscalatorHandrailBlock;
import rbasamoyai.escalated.handrails.WalkwayHandrailBlock;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideEscalatorSideBlock;
import rbasamoyai.escalated.walkways.WideWalkwaySideBlock;

public class EscalatedBuilderTransformersImpl {
    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> walkwayTerminal(String material) {
        ResourceLocation noneLoc = CreateEscalated.resource("walkway_terminal");
        ResourceLocation leftLoc = CreateEscalated.resource("walkway_terminal_left_cap");
        ResourceLocation rightLoc = CreateEscalated.resource("walkway_terminal_right_cap");
        ResourceLocation bothLoc = CreateEscalated.resource("walkway_terminal_both_cap");
        return b -> b.blockstate((c, p) -> p.horizontalBlock((Block)c.get(), state -> {
            WalkwayCaps cap = (WalkwayCaps)((Object)((Object)((Object)((Object)state.getValue(WalkwayBlock.CAPS_SHAFT)))));
            ResourceLocation loc = switch (cap) {
                default -> throw new MatchException(null, null);
                case WalkwayCaps.NONE -> noneLoc;
                case WalkwayCaps.LEFT -> leftLoc;
                case WalkwayCaps.RIGHT -> rightLoc;
                case WalkwayCaps.BOTH, WalkwayCaps.NO_SHAFT -> bothLoc;
            };
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_" + cap.getSerializedName(), loc)).texture("top", "block/" + material + "_walkway_terminal_top")).texture("bottom", "block/" + material + "_walkway_terminal_bottom")).texture("side", "block/" + material + "_walkway_side")).texture("hole", "block/" + material + "_walkway_hole");
        }));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> narrowWalkway(String material) {
        ResourceLocation noneLoc = CreateEscalated.resource(material + "_narrow_walkway");
        ResourceLocation leftLoc = CreateEscalated.resource(material + "_narrow_walkway_left_cap");
        ResourceLocation rightLoc = CreateEscalated.resource(material + "_narrow_walkway_right_cap");
        ResourceLocation bothLoc = CreateEscalated.resource(material + "_narrow_walkway_both_cap");
        return b -> b.blockstate((c, p) -> p.horizontalBlock((Block)c.get(), state -> {
            WalkwayCaps cap = (WalkwayCaps)((Object)((Object)((Object)((Object)state.getValue(WalkwayBlock.CAPS)))));
            ResourceLocation loc = switch (cap) {
                default -> throw new MatchException(null, null);
                case WalkwayCaps.NONE -> noneLoc;
                case WalkwayCaps.LEFT -> leftLoc;
                case WalkwayCaps.RIGHT -> rightLoc;
                case WalkwayCaps.BOTH, WalkwayCaps.NO_SHAFT -> bothLoc;
            };
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_" + cap.getSerializedName(), loc)).texture("top", "block/" + material + "_walkway_top")).texture("bottom", "block/" + material + "_walkway_bottom")).texture("side", "block/" + material + "_walkway_side")).texture("hole", "block/" + material + "_walkway_hole");
        }));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> wideWalkwaySide(String material) {
        ResourceLocation leftLoc = CreateEscalated.resource("wide_walkway_side_left");
        ResourceLocation leftCapLoc = CreateEscalated.resource("wide_walkway_side_left_cap");
        ResourceLocation rightLoc = CreateEscalated.resource("wide_walkway_side_right");
        ResourceLocation rightCapLoc = CreateEscalated.resource("wide_walkway_side_right_cap");
        return b -> b.blockstate((c, p) -> p.horizontalBlock((Block)c.get(), state -> {
            WalkwayCaps cap = (WalkwayCaps)((Object)((Object)((Object)((Object)state.getValue((Property)WideWalkwaySideBlock.CAPS_SIDED)))));
            boolean left = (Boolean)state.getValue((Property)WideWalkwaySideBlock.LEFT);
            ResourceLocation loc = switch (cap) {
                default -> throw new MatchException(null, null);
                case WalkwayCaps.NONE -> {
                    if (left) {
                        yield leftLoc;
                    }
                    yield rightLoc;
                }
                case WalkwayCaps.BOTH, WalkwayCaps.NO_SHAFT -> {
                    if (left) {
                        yield leftCapLoc;
                    }
                    yield rightCapLoc;
                }
                case WalkwayCaps.LEFT, WalkwayCaps.RIGHT -> null;
            };
            String suffix = "_" + (left ? "left" : "right") + "_" + cap.getSerializedName();
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + suffix, loc)).texture("top", "block/" + material + "_walkway_top")).texture("bottom", "block/" + material + "_walkway_bottom")).texture("side", "block/" + material + "_walkway_side")).texture("hole", "block/" + material + "_walkway_hole");
        }));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> wideWalkwayCenter(String material) {
        ResourceLocation centerLoc = CreateEscalated.resource("wide_walkway_side_center");
        return b -> b.blockstate((c, p) -> p.horizontalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), centerLoc)).texture("bottom", "block/" + material + "_walkway_bottom")).texture("side", "block/" + material + "_walkway_side")));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> narrowEscalator(String material) {
        ResourceLocation horizontalLoc = CreateEscalated.resource("narrow_escalator_horizontal");
        ResourceLocation bottomLoc = CreateEscalated.resource("narrow_escalator_bottom");
        ResourceLocation middleLoc = CreateEscalated.resource("narrow_escalator_middle");
        ResourceLocation topLoc = CreateEscalated.resource("narrow_escalator_top");
        return b -> b.blockstate((c, p) -> p.horizontalBlock((Block)c.get(), state -> {
            WalkwaySlope slope = (WalkwaySlope)((Object)((Object)((Object)((Object)state.getValue(WalkwayBlock.SLOPE)))));
            ResourceLocation loc = switch (slope) {
                default -> throw new MatchException(null, null);
                case WalkwaySlope.HORIZONTAL -> horizontalLoc;
                case WalkwaySlope.BOTTOM -> bottomLoc;
                case WalkwaySlope.MIDDLE -> middleLoc;
                case WalkwaySlope.TOP -> topLoc;
                case WalkwaySlope.TERMINAL -> null;
            };
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_" + slope.getSerializedName(), loc)).texture("top", "block/" + material + "_walkway_top")).texture("bottom", "block/" + material + "_walkway_bottom")).texture("walkway_side", "block/" + material + "_walkway_side")).texture("escalator_side", "block/" + material + "_escalator_side")).texture("escalator_bottom_side", "block/" + material + "_escalator_bottom_side")).texture("escalator_top_side", "block/" + material + "_escalator_top_side")).texture("escalator_top_side_1", "block/" + material + "_escalator_top_side_1");
        }, 0));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> wideEscalatorSide(String material) {
        return b -> b.blockstate((c, p) -> p.horizontalBlock((Block)c.get(), state -> {
            WalkwaySlope slope = (WalkwaySlope)((Object)((Object)((Object)((Object)state.getValue((Property)WideEscalatorSideBlock.SLOPE)))));
            boolean left = (Boolean)state.getValue((Property)WideEscalatorSideBlock.LEFT);
            String suffix = "_" + slope.getSerializedName() + "_" + (left ? "left" : "right");
            ResourceLocation modelLoc = CreateEscalated.resource("wide_escalator_side" + suffix);
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + suffix, modelLoc)).texture("top", "block/" + material + "_walkway_top")).texture("bottom", "block/" + material + "_walkway_bottom")).texture("walkway_side", "block/" + material + "_walkway_side")).texture("escalator_side", "block/" + material + "_escalator_side")).texture("escalator_bottom_side", "block/" + material + "_escalator_bottom_side")).texture("escalator_top_side", "block/" + material + "_escalator_top_side")).texture("escalator_top_side_1", "block/" + material + "_escalator_top_side_1");
        }, 0));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> wideEscalatorCenter(String material) {
        ResourceLocation horizontalLoc = CreateEscalated.resource("wide_escalator_center_horizontal");
        ResourceLocation bottomLoc = CreateEscalated.resource("wide_escalator_center_bottom");
        ResourceLocation middleLoc = CreateEscalated.resource("wide_escalator_center_middle");
        ResourceLocation topLoc = CreateEscalated.resource("wide_escalator_center_top");
        return b -> b.blockstate((c, p) -> p.horizontalBlock((Block)c.get(), state -> {
            WalkwaySlope slope = (WalkwaySlope)((Object)((Object)((Object)((Object)state.getValue(WalkwayBlock.SLOPE)))));
            ResourceLocation loc = switch (slope) {
                default -> throw new MatchException(null, null);
                case WalkwaySlope.HORIZONTAL -> horizontalLoc;
                case WalkwaySlope.BOTTOM -> bottomLoc;
                case WalkwaySlope.MIDDLE -> middleLoc;
                case WalkwaySlope.TOP -> topLoc;
                case WalkwaySlope.TERMINAL -> null;
            };
            return ((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_" + slope.getSerializedName(), loc)).texture("bottom", "block/" + material + "_walkway_bottom");
        }, 0));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> walkwayHandrail(String material) {
        return b -> b.blockstate((c, p) -> p.horizontalBlock((Block)c.get(), state -> {
            String suffix = ((AbstractHandrailBlock.Side)((Object)((Object)((Object)((Object)state.getValue((Property)WalkwayHandrailBlock.SIDE)))))).getSerializedName() + "_";
            suffix = state.getValue(WalkwayHandrailBlock.PART) == WalkwayHandrailBlock.Part.MIDDLE ? suffix + "horizontal" : suffix + ((WalkwayHandrailBlock.Part)((Object)((Object)((Object)((Object)state.getValue(WalkwayHandrailBlock.PART)))))).getSerializedName();
            ResourceLocation loc = CreateEscalated.resource("block/handrail_wall/" + suffix);
            return ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_" + suffix, loc)).texture("side", "block/" + material + "_handrail_side")).texture("edge", "block/" + material + "_handrail_edge");
        }));
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> escalatorHandrail(String material) {
        return b -> b.blockstate((c, p) -> p.horizontalBlock((Block)c.get(), state -> {
            String suffix = ((AbstractHandrailBlock.Side)((Object)((Object)((Object)((Object)state.getValue((Property)EscalatorHandrailBlock.SIDE)))))).getSerializedName() + "_" + ((EscalatorHandrailBlock.Part)((Object)((Object)((Object)((Object)state.getValue(EscalatorHandrailBlock.PART)))))).getSerializedName();
            ResourceLocation loc = CreateEscalated.resource("block/handrail_wall/" + suffix);
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + "_" + suffix, loc)).texture("side", "block/" + material + "_handrail_side")).texture("edge", "block/" + material + "_handrail_edge")).texture("escalator_side", "block/" + material + "_handrail_escalator_side")).texture("escalator_side1", "block/" + material + "_handrail_escalator_side1");
        }));
    }

    public static <T extends Item, P> NonNullUnaryOperator<ItemBuilder<T, P>> existingItemModel() {
        return b -> b.model((c, p) -> {});
    }
}

