/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.client.model;

import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.ModBlocks;

public final class ModPartialModels {
    public static final List<VibrantFrogportPartialModels> VIBRANT_FROGPORTS = ModPartialModels.getVibrantFrogports();
    public static final List<VibrantPackagerPartialModels> VIBRANT_PACKAGERS = ModPartialModels.getVibrantPackagers();
    public static final List<VibrantGaugePartialModels> VIBRANT_GAUGES = ModPartialModels.getVibrantGauges();

    private ModPartialModels() {
    }

    public static VibrantFrogportPartialModels ofVibrantFrogport(ModBlocks.VibrantVaultColor color) {
        return VIBRANT_FROGPORTS.get(color.ordinal());
    }

    public static VibrantPackagerPartialModels ofVibrantPackager(ModBlocks.VibrantVaultColor color) {
        return VIBRANT_PACKAGERS.get(color.ordinal());
    }

    public static VibrantGaugePartialModels ofVibrantGauge(ModBlocks.VibrantVaultColor color) {
        return VIBRANT_GAUGES.get(color.ordinal());
    }

    private static PartialModel block(String path) {
        return PartialModel.of((ResourceLocation)CreateVibrantVaults.asResource("block/" + path));
    }

    private static List<VibrantFrogportPartialModels> getVibrantFrogports() {
        ModBlocks.VibrantVaultColor[] colors = ModBlocks.VibrantVaultColor.values();
        ArrayList<VibrantFrogportPartialModels> result = new ArrayList<VibrantFrogportPartialModels>(colors.length - 1);
        for (ModBlocks.VibrantVaultColor color : colors) {
            if (color == ModBlocks.VibrantVaultColor.BASE) continue;
            result.add(color.ordinal(), new VibrantFrogportPartialModels(color));
        }
        return result;
    }

    private static List<VibrantPackagerPartialModels> getVibrantPackagers() {
        ModBlocks.VibrantVaultColor[] colors = ModBlocks.VibrantVaultColor.values();
        ArrayList<VibrantPackagerPartialModels> result = new ArrayList<VibrantPackagerPartialModels>(colors.length - 1);
        for (ModBlocks.VibrantVaultColor color : colors) {
            if (color == ModBlocks.VibrantVaultColor.BASE) continue;
            result.add(color.ordinal(), new VibrantPackagerPartialModels(color));
        }
        return result;
    }

    private static List<VibrantGaugePartialModels> getVibrantGauges() {
        ModBlocks.VibrantVaultColor[] colors = ModBlocks.VibrantVaultColor.values();
        ArrayList<VibrantGaugePartialModels> result = new ArrayList<VibrantGaugePartialModels>(colors.length - 1);
        for (ModBlocks.VibrantVaultColor color : colors) {
            if (color == ModBlocks.VibrantVaultColor.BASE) continue;
            result.add(color.ordinal(), new VibrantGaugePartialModels(color));
        }
        return result;
    }

    public static void init() {
    }

    public static class VibrantFrogportPartialModels {
        public final PartialModel body;
        public final PartialModel head;
        public final PartialModel headGoggles;
        public final PartialModel tongue;

        public VibrantFrogportPartialModels(ModBlocks.VibrantVaultColor color) {
            String vibrantFrogportName = color.asId() + "_package_frogport";
            this.body = ModPartialModels.block(vibrantFrogportName + "/body");
            this.head = ModPartialModels.block(vibrantFrogportName + "/head");
            this.headGoggles = ModPartialModels.block(vibrantFrogportName + "/head_goggles");
            this.tongue = ModPartialModels.block(vibrantFrogportName + "/tongue");
        }
    }

    public static class VibrantPackagerPartialModels {
        public final PartialModel trayRegular;
        public final PartialModel hatchOpen;
        public final PartialModel hatchClosed;

        public VibrantPackagerPartialModels(ModBlocks.VibrantVaultColor color) {
            String vibrantPackagerName = color.asId() + "_packager";
            this.trayRegular = ModPartialModels.block(vibrantPackagerName + "/tray");
            this.hatchOpen = ModPartialModels.block(vibrantPackagerName + "/hatch_open");
            this.hatchClosed = ModPartialModels.block(vibrantPackagerName + "/hatch_closed");
        }
    }

    public static class VibrantGaugePartialModels {
        public final PartialModel restocker;
        public final PartialModel restockerWithBulb;

        public VibrantGaugePartialModels(ModBlocks.VibrantVaultColor color) {
            String vibrantGaugeName = color.asId() + "_factory_gauge";
            this.restocker = ModPartialModels.block(vibrantGaugeName + "/panel_restocker");
            this.restockerWithBulb = ModPartialModels.block(vibrantGaugeName + "/panel_restocker_with_bulb");
        }
    }
}

