/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.MoltenVents.api.biome.features.types;

import com.Apothic0n.MoltenVents.api.biome.features.configurations.MoltenVentConfiguration;
import com.Apothic0n.MoltenVents.config.CommonConfig;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class MoltenVentFeature
extends Feature<MoltenVentConfiguration> {
    public MoltenVentFeature(Codec<MoltenVentConfiguration> pContext) {
        super(pContext);
    }

    public boolean place(FeaturePlaceContext<MoltenVentConfiguration> pContext) {
        MoltenVentConfiguration ventConfiguration = (MoltenVentConfiguration)pContext.config();
        RandomSource random = pContext.random();
        BlockPos origin = pContext.origin();
        WorldGenLevel worldGenLevel = pContext.level();
        BlockStateProvider decorativeBlock = ventConfiguration.getDecorativeBlock();
        BlockStateProvider outerBlock = ventConfiguration.getOuterBlock();
        BlockStateProvider innerBlock = ventConfiguration.getInnerBlock();
        BlockStateProvider liquidBlock = ventConfiguration.getLiquidBlock();
        Boolean underwater = ventConfiguration.underwater;
        if (underwater.booleanValue() && !((Boolean)CommonConfig.generateUnderwaterVents.get()).booleanValue() || !underwater.booleanValue() && !((Boolean)CommonConfig.generateLandVents.get()).booleanValue()) {
            return false;
        }
        int depth = ventConfiguration.getDepth().sample(random);
        boolean suitableEnvironment = false;
        if (depth > 80 && underwater.booleanValue()) {
            depth = 80;
        }
        if (underwater.booleanValue() && worldGenLevel.getBlockState(origin.above(2)).is(Blocks.WATER)) {
            suitableEnvironment = true;
        } else if (!underwater.booleanValue() && !worldGenLevel.getBlockState(origin.below()).is(Blocks.WATER)) {
            suitableEnvironment = true;
        }
        if (suitableEnvironment && worldGenLevel.getBlockState(origin.below()).isSolid()) {
            this.placePartialDiagonal(worldGenLevel, random, origin.above(), outerBlock, 3, 0.8, decorativeBlock);
            this.placeDiagonal(worldGenLevel, random, origin.above(), outerBlock, 3, 3, 0.66, decorativeBlock);
            this.placePartialDiagonal(worldGenLevel, random, origin, outerBlock, 3, 0.7, decorativeBlock);
            this.placeStraight(worldGenLevel, random, origin, outerBlock, 3, 3, 1.0, decorativeBlock);
            this.placeDiagonal(worldGenLevel, random, origin, outerBlock, 0, 3, 1.6, null);
            this.placeStraight(worldGenLevel, random, origin.below(), outerBlock, 3, 3, 1.0, null);
            this.placeDiagonal(worldGenLevel, random, origin.below(), outerBlock, 0, 3, 1.6, null);
            if (depth > 10) {
                int y;
                for (y = 1; y <= depth / 2 + 1; ++y) {
                    this.placeStraight(worldGenLevel, random, origin.below(y), outerBlock, 0, 2, 0.8, null);
                    this.placeDiagonal(worldGenLevel, random, origin.below(y), outerBlock, 0, 2, 0.75, null);
                    this.placeBlock(worldGenLevel, random, origin.below(y), liquidBlock, 1.0, null);
                }
                for (y = depth / 2 + 2; y <= depth + 1; ++y) {
                    this.placeStraight(worldGenLevel, random, origin.below(y), outerBlock, 0, 1, 0.33, null);
                    this.placeDiagonal(worldGenLevel, random, origin.below(y), outerBlock, 0, 1, 0.275, null);
                    this.placeBlock(worldGenLevel, random, origin.below(y), liquidBlock, 1.0, null);
                }
            }
            if (underwater.booleanValue()) {
                worldGenLevel.setBlock(origin, Blocks.WATER.defaultBlockState(), 3);
            } else {
                worldGenLevel.setBlock(origin, Blocks.AIR.defaultBlockState(), 3);
            }
            worldGenLevel.setBlock(origin.below(), innerBlock.getState(random, origin.below()), 3);
            return true;
        }
        return false;
    }

    private void placeStraight(WorldGenLevel worldGenLevel, RandomSource random, BlockPos blockPos, BlockStateProvider blockStateProvider, int minRadius, int maxRadius, double probability, @Nullable BlockStateProvider decorate) {
        for (int radius = --minRadius; radius < maxRadius; ++radius) {
            this.placeBlock(worldGenLevel, random, blockPos.north(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.east(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.south(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.west(radius), blockStateProvider, probability, decorate);
        }
    }

    private void placeDiagonal(WorldGenLevel worldGenLevel, RandomSource random, BlockPos blockPos, BlockStateProvider blockStateProvider, int minRadius, int maxRadius, double probability, @Nullable BlockStateProvider decorate) {
        for (int radius = --minRadius; radius < maxRadius; ++radius) {
            this.placeBlock(worldGenLevel, random, blockPos.north(radius).east(), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.north(radius).west(), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.south(radius).west(), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.south(radius).east(), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.north().east(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.north().west(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.south().west(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.south().east(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.north(radius).east(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.north(radius).west(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.south(radius).west(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.south(radius).east(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.north(radius).east(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.north(radius).west(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.south(radius).west(radius), blockStateProvider, probability, decorate);
            this.placeBlock(worldGenLevel, random, blockPos.south(radius).east(radius), blockStateProvider, probability, decorate);
        }
    }

    private void placePartialDiagonal(WorldGenLevel worldGenLevel, RandomSource random, BlockPos blockPos, BlockStateProvider blockStateProvider, int radius, double probability, @Nullable BlockStateProvider decorate) {
        this.placeBlock(worldGenLevel, random, blockPos.north(radius).east(), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.north(radius).west(), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.south(radius).west(), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.south(radius).east(), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.north().east(radius), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.north().west(radius), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.south().west(radius), blockStateProvider, probability, decorate);
        this.placeBlock(worldGenLevel, random, blockPos.south().east(radius), blockStateProvider, probability, decorate);
    }

    private void placeBlock(WorldGenLevel worldGenLevel, RandomSource random, BlockPos blockPos, BlockStateProvider blockStateProvider, double probability, @Nullable BlockStateProvider decorate) {
        boolean passedProbability = false;
        if (probability >= 1.0) {
            passedProbability = true;
        } else {
            int randomNumber = (int)(Math.random() * 100.0 + 1.0);
            if ((double)randomNumber < probability * 100.0) {
                passedProbability = true;
            }
        }
        if (passedProbability) {
            BlockState blockState = blockStateProvider.getState(random, blockPos);
            worldGenLevel.setBlock(blockPos, blockState, 3);
            if (decorate != null) {
                boolean passedDecorateProbability = false;
                double decorateProbability = probability / 3.0;
                if (decorateProbability >= 1.0) {
                    passedDecorateProbability = true;
                } else {
                    int randomNumber2 = (int)(Math.random() * 100.0 + 1.0);
                    if ((double)randomNumber2 < decorateProbability * 100.0) {
                        passedDecorateProbability = true;
                    }
                }
                if (passedDecorateProbability) {
                    BlockPos offsetPos = this.randomOffset(blockPos);
                    BlockState decorateBlockState = decorate.getState(random, offsetPos);
                    worldGenLevel.setBlock(offsetPos, decorateBlockState, 3);
                    if (worldGenLevel.getBlockState(offsetPos.below()).isAir()) {
                        worldGenLevel.setBlock(offsetPos.below(), blockState, 3);
                    }
                }
            }
        }
    }

    private BlockPos randomOffset(BlockPos blockPos) {
        int randomNumber = (int)(Math.random() * 15.0 + 1.0);
        if (randomNumber <= 7) {
            return blockPos.above();
        }
        if (randomNumber == 8) {
            return blockPos.north();
        }
        if (randomNumber == 9) {
            return blockPos.east();
        }
        if (randomNumber == 10) {
            return blockPos.south();
        }
        if (randomNumber == 11) {
            return blockPos.west();
        }
        if (randomNumber == 12) {
            return blockPos.north().east();
        }
        if (randomNumber == 13) {
            return blockPos.north().west();
        }
        if (randomNumber == 14) {
            return blockPos.south().east();
        }
        return blockPos.south().west();
    }
}

