/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.import_export;

import java.io.File;
import journeymap.client.io.FileHandler;
import journeymap.client.log.ChatLog;
import journeymap.client.ui.component.screens.AbstractPopupScreen;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.dialog.import_export.ExportPopup;
import journeymap.client.ui.dialog.import_export.ImportFolderPopup;
import journeymap.client.ui.dialog.import_export.ImportZipPopup;
import journeymap.common.Journeymap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class ImportExportPopup
extends AbstractPopupScreen {
    public ImportExportPopup() {
        super((Component)Component.translatable((String)"jm.common.importexport_dialog"));
    }

    public void init() {
        this.layout.spacing(6);
        this.layout.defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new StringWidget((Component)this.getTitle().copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), LayoutSettings::alignHorizontallyCenter);
        LinearLayout buttonLayout = LinearLayout.vertical();
        buttonLayout.spacing(10);
        buttonLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.importexport_dialog_export"), button -> new ExportPopup().display()).build());
        buttonLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.importexport_dialog_import_zip"), button -> this.importZipFile()).build());
        buttonLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.importexport_dialog_import_folder"), button -> this.importFolder()).build());
        buttonLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.close"), button -> this.onClose()).build());
        this.layout.addChild((LayoutElement)buttonLayout);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        super.repositionElements();
    }

    private void importZipFile() {
        String result;
        File jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
        if (jmWorldDir == null || !jmWorldDir.exists()) {
            ChatLog.announceError("No world is currently loaded. Please load a world first.");
            return;
        }
        File screenshotsDir = new File(FileHandler.getMinecraftDirectory(), "screenshots");
        if (!screenshotsDir.exists()) {
            screenshotsDir.mkdir();
        }
        String startingPath = screenshotsDir.getAbsolutePath() + File.separator;
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filterPatterns = stack.mallocPointer(1);
            filterPatterns.put(stack.UTF8((CharSequence)"*.zip"));
            filterPatterns.flip();
            result = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Select ZIP File to Import", (CharSequence)startingPath, (PointerBuffer)filterPatterns, (CharSequence)"ZIP Files", (boolean)false);
        }
        if (result != null) {
            File selectedFile = new File(result);
            if (!selectedFile.exists()) {
                ChatLog.announceError("Selected file does not exist.");
                return;
            }
            if (selectedFile.isFile() && selectedFile.getName().toLowerCase().endsWith(".zip")) {
                new ImportZipPopup(selectedFile).display();
            } else {
                ChatLog.announceError(Component.translatable((String)"jm.common.importexport_dialog_no_zip").getString());
            }
        } else {
            Journeymap.getLogger().info("Import cancelled by user");
        }
    }

    private void importFolder() {
        File jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
        if (jmWorldDir == null || !jmWorldDir.exists()) {
            ChatLog.announceError("No world is currently loaded. Please load a world first.");
            return;
        }
        File startingDir = jmWorldDir;
        String startingPath = startingDir != null ? startingDir.getAbsolutePath() : null;
        String result = TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)"Select Folder to Import", (CharSequence)startingPath);
        if (result != null) {
            File selectedFolder = new File(result);
            if (!selectedFolder.exists() || !selectedFolder.isDirectory()) {
                ChatLog.announceError("Selected folder does not exist or is not a directory.");
                return;
            }
            new ImportFolderPopup(selectedFolder).display();
        } else {
            Journeymap.getLogger().info("Import cancelled by user");
        }
    }

    public static class DimensionFolder {
        final String name;
        final File folder;

        DimensionFolder(String name, File folder) {
            this.name = name;
            this.folder = folder;
        }
    }
}

