/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeWrapper;

public class PumpUpgradeContainer
extends UpgradeContainerBase<PumpUpgradeWrapper, PumpUpgradeContainer> {
    private static final String DATA_IS_INPUT = "isInput";
    private static final String DATA_INTERACT_WITH_HAND = "interactWithHand";
    private static final String DATA_INTERACT_WITH_WORLD = "interactWithWorld";
    private final FluidFilterContainer fluidFilterContainer;

    public PumpUpgradeContainer(Player player, int upgradeContainerId, PumpUpgradeWrapper upgradeWrapper, UpgradeContainerType<PumpUpgradeWrapper, PumpUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        this.fluidFilterContainer = new FluidFilterContainer(player, this, upgradeWrapper::getFluidFilterLogic);
    }

    public void setIsInput(boolean input) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setIsInput(input);
        this.sendBooleanToServer(DATA_IS_INPUT, input);
    }

    public boolean isInput() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).isInput();
    }

    @Override
    public void handlePacket(CompoundTag data) {
        if (data.contains(DATA_IS_INPUT)) {
            this.setIsInput(data.getBoolean(DATA_IS_INPUT));
        } else if (data.contains(DATA_INTERACT_WITH_HAND)) {
            this.setInteractWithHand(data.getBoolean(DATA_INTERACT_WITH_HAND));
        } else if (data.contains(DATA_INTERACT_WITH_WORLD)) {
            this.setInteractWithWorld(data.getBoolean(DATA_INTERACT_WITH_WORLD));
        }
        this.fluidFilterContainer.handlePacket(data);
    }

    public FluidFilterContainer getFluidFilterContainer() {
        return this.fluidFilterContainer;
    }

    public void setInteractWithHand(boolean interactWithHand) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setInteractWithHand(interactWithHand);
        this.sendBooleanToServer(DATA_INTERACT_WITH_HAND, interactWithHand);
    }

    public boolean shouldInteractWithHand() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).shouldInteractWithHand();
    }

    public void setInteractWithWorld(boolean interactWithWorld) {
        ((PumpUpgradeWrapper)this.upgradeWrapper).setInteractWithWorld(interactWithWorld);
        this.sendBooleanToServer(DATA_INTERACT_WITH_WORLD, interactWithWorld);
    }

    public boolean shouldInteractWithWorld() {
        return ((PumpUpgradeWrapper)this.upgradeWrapper).shouldInteractWithWorld();
    }
}

