/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.integration;

import com.supermartijn642.pottery.content.PotRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

@JeiPlugin
public class PotteryJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"pottery", (String)"pot_recipes");
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(PotRecipe.class, (ICraftingCategoryExtension)new ICraftingCategoryExtension<PotRecipe>(this){

            public void setRecipe(RecipeHolder<PotRecipe> recipeHolder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
                PotRecipe recipe = (PotRecipe)recipeHolder.value();
                int width = this.getWidth(recipeHolder);
                int height = this.getHeight(recipeHolder);
                List inputs = recipe.getIngredients().stream().map(Ingredient::getItems).map(Arrays::asList).collect(Collectors.toCollection(ArrayList::new));
                Ingredient dyeIngredient = recipe.getDyeIngredient();
                if (dyeIngredient != null) {
                    for (int i = 0; i < inputs.size(); ++i) {
                        if (!((List)inputs.get(i)).isEmpty()) continue;
                        inputs.set(i, Arrays.asList(dyeIngredient.getItems()));
                        break;
                    }
                }
                craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
                ItemStack resultItem = RecipeUtil.getResultItem((Recipe)recipe);
                craftingGridHelper.createAndSetOutputs(builder, List.of(resultItem));
            }

            public Optional<ResourceLocation> getRegistryName(RecipeHolder<PotRecipe> recipeHolder) {
                return Optional.of(recipeHolder.id());
            }

            public int getWidth(RecipeHolder<PotRecipe> recipeHolder) {
                return ((PotRecipe)recipeHolder.value()).getWidth();
            }

            public int getHeight(RecipeHolder<PotRecipe> recipeHolder) {
                return ((PotRecipe)recipeHolder.value()).getHeight();
            }
        });
    }
}

