/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.generators;

import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.util.Triple;
import com.supermartijn642.pottery.content.PotColor;
import com.supermartijn642.pottery.content.PotType;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;

public class PotteryTextureGenerator
extends ResourceGenerator {
    private final List<Triple<ResourceLocation, String, PotColor>> hueShifts = new ArrayList<Triple<ResourceLocation, String, PotColor>>();

    public PotteryTextureGenerator(ResourceCache cache) {
        super("pottery", cache);
    }

    public void generate() {
        for (PotType potType : PotType.values()) {
            for (PotColor color : PotColor.values()) {
                if (color == PotColor.BLANK) continue;
                String from = potType.getIdentifier() + "/" + potType.getIdentifier(PotColor.BLANK);
                String to = potType.getIdentifier() + "/" + potType.getIdentifier(color);
                this.hueShifts.add((Triple<ResourceLocation, String, PotColor>)Triple.of((Object)ResourceLocation.fromNamespaceAndPath((String)"pottery", (String)from), (Object)to, (Object)((Object)color)));
                this.cache.trackToBeGeneratedResource(ResourceType.ASSET, this.modid, "textures", to, ".png");
                if (potType == PotType.DEFAULT) continue;
                this.hueShifts.add((Triple<ResourceLocation, String, PotColor>)Triple.of((Object)ResourceLocation.fromNamespaceAndPath((String)"pottery", (String)(from + "_side")), (Object)(to + "_side"), (Object)((Object)color)));
                this.cache.trackToBeGeneratedResource(ResourceType.ASSET, this.modid, "textures", to + "_side", ".png");
                this.hueShifts.add((Triple<ResourceLocation, String, PotColor>)Triple.of((Object)ResourceLocation.fromNamespaceAndPath((String)"pottery", (String)(from + "_side_decorated")), (Object)(to + "_side_decorated"), (Object)((Object)color)));
                this.cache.trackToBeGeneratedResource(ResourceType.ASSET, this.modid, "textures", to + "_side_decorated", ".png");
            }
        }
        for (Enum enum_ : PotColor.values()) {
            if (enum_ == PotColor.BLANK) continue;
            BuiltInRegistries.DECORATED_POT_PATTERN.holders().filter(holder -> holder.key().location().getNamespace().equals("minecraft")).map(holder -> ((DecoratedPotPattern)holder.value()).assetId().withPrefix("entity/decorated_pot/")).forEach(arg_0 -> this.lambda$generate$2((PotColor)enum_, arg_0));
        }
    }

    public void save() {
        for (Triple<ResourceLocation, String, PotColor> entry : this.hueShifts) {
            BufferedImage image = this.readImage((ResourceLocation)entry.left());
            PotteryTextureGenerator.hueShiftImage(image, (PotColor)((Object)entry.right()));
            this.cache.saveResource(ResourceType.ASSET, PotteryTextureGenerator.writeImage(image), this.modid, "textures", (String)entry.middle(), ".png");
        }
    }

    private BufferedImage readImage(ResourceLocation file) {
        BufferedImage bufferedImage;
        block10: {
            IModFileInfo modFile = ModList.get().getModFileById(file.getNamespace());
            if (modFile == null) {
                throw new RuntimeException("Could not find mod for namespace '" + file.getNamespace() + "' for texture '" + String.valueOf(file) + "'!");
            }
            Path filePath = modFile.getFile().findResource(new String[]{"assets", file.getNamespace(), "textures", file.getPath() + ".png"});
            if (filePath == null) {
                throw new RuntimeException("Could not find file 'assets/" + file.getNamespace() + "/textures/" + file.getPath() + ".png' from mod '" + file.getNamespace() + "'!");
            }
            InputStream stream = Files.newInputStream(filePath, new OpenOption[0]);
            try {
                BufferedImage image = ImageIO.read(stream);
                BufferedImage redrawn = new BufferedImage(image.getWidth(), image.getHeight(), 2);
                redrawn.getGraphics().drawImage(image, 0, 0, null);
                bufferedImage = redrawn;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return bufferedImage;
    }

    private static void hueShiftImage(BufferedImage image, PotColor color) {
        float[] hsb = new float[3];
        ColorModel colorModel = ColorModel.getRGBdefault();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int rgb = image.getRGB(x, y);
                if (colorModel.getAlpha(rgb) == 0) continue;
                Color.RGBtoHSB(colorModel.getRed(rgb), colorModel.getGreen(rgb), colorModel.getBlue(rgb), hsb);
                hsb[0] = hsb[0] + (float)color.getHueShift() / 360.0f;
                hsb[0] = hsb[0] % 1.0f;
                hsb[1] = hsb[1] * ((float)color.getSaturationShift() / 100.0f);
                hsb[1] = Math.max(0.0f, Math.min(1.0f, hsb[1]));
                hsb[2] = hsb[2] * (1.0f + (float)color.getBrightnessShift() / 100.0f);
                hsb[2] = Math.max(0.0f, Math.min(1.0f, hsb[2]));
                rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
                image.setRGB(x, y, rgb);
            }
        }
    }

    private static byte[] writeImage(BufferedImage image) {
        byte[] byArray;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", stream);
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return byArray;
    }

    public String getName() {
        return this.modName + " Texture Generator";
    }

    private /* synthetic */ void lambda$generate$2(PotColor color, ResourceLocation texture) {
        String to = "patterns/" + color.getIdentifier() + "/" + texture.getPath().substring(texture.getPath().lastIndexOf(47) + 1);
        this.hueShifts.add((Triple<ResourceLocation, String, PotColor>)Triple.of((Object)texture, (Object)to, (Object)((Object)color)));
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, this.modid, "textures", to, ".png");
    }
}

