/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.generators;

import com.supermartijn642.core.generator.LootTableGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.pottery.content.PotColor;
import com.supermartijn642.pottery.content.PotType;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;

public class PotteryLootTableGenerator
extends LootTableGenerator {
    public PotteryLootTableGenerator(ResourceCache cache) {
        super("pottery", cache);
    }

    public void generate() {
        for (PotType type : PotType.values()) {
            for (PotColor color : PotColor.values()) {
                if (type == PotType.DEFAULT && color == PotColor.BLANK) continue;
                Block block = type.getBlock(color);
                this.lootTable(block).blockParameters().pool(pool -> pool.entry(((LootPoolSingletonContainer.Builder)DynamicLoot.dynamicEntry((ResourceLocation)DecoratedPotBlock.SHERDS_DYNAMIC_DROP_ID).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.BREAKS_DECORATED_POTS)))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.POT_DECORATIONS))).build()));
            }
        }
    }
}

