/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.content;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.PotDecorations;

public class PotRecipe
extends ShapedRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient dyeIngredient;
    private final int[] sherdIndices;

    public PotRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack output, boolean showNotification, Ingredient dyeIngredient, int[] sherdIndices) {
        super(group, category, pattern, output, showNotification);
        this.dyeIngredient = dyeIngredient;
        this.sherdIndices = sherdIndices;
    }

    public Ingredient getDyeIngredient() {
        return this.dyeIngredient;
    }

    public boolean matches(CraftingInput input, Level level) {
        return this.findRecipeDecorations(input) != null;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack stack = super.assemble(input, provider);
        PotDecorations decorations = this.findRecipeDecorations(input);
        Objects.requireNonNull(decorations);
        if (!decorations.equals((Object)PotDecorations.EMPTY)) {
            stack.set(DataComponents.POT_DECORATIONS, (Object)decorations);
        }
        return stack;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private PotDecorations findRecipeDecorations(CraftingInput input) {
        if (!this.canCraftInDimensions(input.width(), input.height())) {
            return null;
        }
        for (int x = 0; x <= input.width() - this.getWidth(); ++x) {
            for (int y = 0; y <= input.height() - this.getHeight(); ++y) {
                PotDecorations decorations = this.matchesSubGrid(input, x, y, true);
                if (decorations == null) {
                    decorations = this.matchesSubGrid(input, x, y, false);
                }
                if (decorations == null) continue;
                return decorations;
            }
        }
        return null;
    }

    private PotDecorations matchesSubGrid(CraftingInput input, int startX, int startY, boolean mirrored) {
        boolean foundDye = false;
        for (int x = 0; x < input.width(); ++x) {
            for (int y = 0; y < input.height(); ++y) {
                Ingredient ingredient;
                ItemStack stack = input.getItem(x + y * input.width());
                if (this.dyeIngredient != null && this.dyeIngredient.test(stack)) {
                    if (foundDye) {
                        return null;
                    }
                    foundDye = true;
                    continue;
                }
                int relativeX = x - startX;
                int relativeY = y - startY;
                if (!(relativeX >= 0 && relativeY >= 0 && relativeX < this.getWidth() && relativeY < this.getHeight() ? !(ingredient = (Ingredient)this.getIngredients().get(mirrored ? this.getWidth() - relativeX - 1 + relativeY * this.getWidth() : relativeX + relativeY * this.getWidth())).test(stack) : !Ingredient.EMPTY.test(stack))) continue;
                return null;
            }
        }
        if (this.dyeIngredient != null && !foundDye) {
            return null;
        }
        Item front = input.getItem(startX + this.sherdIndices[0] % this.getWidth() + (startY + this.sherdIndices[0] / this.getWidth()) * input.width()).getItem();
        Item left = input.getItem(startX + this.sherdIndices[1] % this.getWidth() + (startY + this.sherdIndices[1] / this.getWidth()) * input.width()).getItem();
        Item right = input.getItem(startX + this.sherdIndices[2] % this.getWidth() + (startY + this.sherdIndices[2] / this.getWidth()) * input.width()).getItem();
        Item back = input.getItem(startX + this.sherdIndices[3] % this.getWidth() + (startY + this.sherdIndices[3] / this.getWidth()) * input.width()).getItem();
        return new PotDecorations(back, left, right, front);
    }

    public static class Serializer
    implements RecipeSerializer<PotRecipe> {
        private static final Function<Integer, DataResult<Integer>> GEQUAL_TO_ZERO = integer -> integer < 0 ? DataResult.error(() -> "Value '" + integer + "' is less than 0!") : DataResult.success((Object)integer);
        private static final MapCodec<PotRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapedRecipe.Serializer.CODEC.fieldOf("recipe").forGetter(recipe -> null), (App)Ingredient.CODEC_NONEMPTY.optionalFieldOf("dye_ingredient").forGetter(recipe -> Optional.of(recipe.dyeIngredient)), (App)Codec.INT.flatXmap(GEQUAL_TO_ZERO, GEQUAL_TO_ZERO).listOf().fieldOf("sherds").forGetter(recipe -> IntStream.of(recipe.sherdIndices).boxed().toList())).apply((Applicative)instance, (shapedRecipe, dyeIngredient, sherdIndices) -> new PotRecipe(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, shapedRecipe.getResultItem(null), shapedRecipe.showNotification(), dyeIngredient.orElse(null), sherdIndices.stream().mapToInt(i -> i).toArray())));
        private static final StreamCodec<RegistryFriendlyByteBuf, PotRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<PotRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static PotRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.streamCodec().decode((Object)buffer);
            Ingredient dyeIngredient = buffer.readBoolean() ? (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer) : null;
            int[] sherdIndices = buffer.readVarIntArray(4);
            if (sherdIndices.length != 4) {
                throw new IllegalArgumentException();
            }
            return new PotRecipe(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, shapedRecipe.getResultItem(null), shapedRecipe.showNotification(), dyeIngredient, sherdIndices);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, PotRecipe recipe) {
            RecipeSerializer.SHAPED_RECIPE.streamCodec().encode((Object)buffer, (Object)recipe);
            buffer.writeBoolean(recipe.dyeIngredient != null);
            if (recipe.dyeIngredient != null) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.dyeIngredient);
            }
            buffer.writeVarIntArray(recipe.sherdIndices);
        }
    }
}

