/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.pottery.content;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.TextureAtlases;
import com.supermartijn642.pottery.content.DecorationUtils;
import com.supermartijn642.pottery.content.PotBlock;
import com.supermartijn642.pottery.content.PotBlockEntity;
import com.supermartijn642.pottery.content.PotColor;
import com.supermartijn642.pottery.content.PotType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotBakedModel
implements BakedModel,
IDynamicBakedModel {
    private static final ResourceLocation DUMMY_PATTERN_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"pottery", (String)"dummy_pattern");
    private static final int BLOCK_VERTEX_DATA_UV_OFFSET = PotBakedModel.findUVOffset(DefaultVertexFormat.BLOCK);
    private static final PotData DEFAULT_POT_DATA = new PotData(PotType.DEFAULT, PotColor.BLANK, Direction.NORTH, PotDecorations.EMPTY);
    private static final ModelProperty<PotData> MODEL_PROPERTY = new ModelProperty();
    private final BakedModel original;
    private PotData itemModelData;

    public PotBakedModel(BakedModel original) {
        this.original = original;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        BlockEntity entity;
        if (!(state.getBlock() instanceof PotBlock) || !((entity = level.getBlockEntity(pos)) instanceof PotBlockEntity)) {
            return modelData;
        }
        PotType type = ((PotBlock)state.getBlock()).getType();
        PotColor color = ((PotBlock)state.getBlock()).getColor();
        PotDecorations decorations = ((PotBlockEntity)entity).getDecorations();
        Direction facing = (Direction)state.getValue((Property)PotBlock.HORIZONTAL_FACING);
        return ModelData.builder().with(MODEL_PROPERTY, (Object)new PotData(type, color, facing, decorations)).build();
    }

    public List<BakedModel> getRenderPasses(ItemStack stack, boolean fabulous) {
        Block block;
        Block block2 = block = stack.getItem() instanceof BlockItem ? ((BlockItem)stack.getItem()).getBlock() : null;
        if (block == null || !(block instanceof PotBlock)) {
            return List.of(this);
        }
        PotType type = ((PotBlock)block).getType();
        PotColor color = ((PotBlock)block).getColor();
        PotDecorations decorations = (PotDecorations)stack.get(DataComponents.POT_DECORATIONS);
        if (decorations == null) {
            decorations = PotDecorations.EMPTY;
        }
        this.itemModelData = new PotData(type, color, Direction.SOUTH, decorations);
        return List.of(this);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource random, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        PotData data;
        PotData potData = data = modelData.has(MODEL_PROPERTY) ? (PotData)modelData.get(MODEL_PROPERTY) : DEFAULT_POT_DATA;
        if (data == DEFAULT_POT_DATA && state == null && this.itemModelData != null) {
            data = this.itemModelData;
        }
        PotData finalData = data;
        return this.original.getQuads(state, side, random).stream().map(quad -> this.adjustQuad((BakedQuad)quad, finalData)).toList();
    }

    private BakedQuad adjustQuad(BakedQuad quad, PotData data) {
        Optional<Item> decorationItem;
        if (quad.getDirection().getAxis().isVertical()) {
            return quad;
        }
        TextureAtlasSprite sprite = quad.getSprite();
        ResourceLocation spriteName = sprite.contents().name();
        if (DUMMY_PATTERN_SPRITE.equals((Object)spriteName)) {
            Item decorationItem2 = DecorationUtils.getDecorationItem(data.decorations, data.facing, quad.getDirection()).orElse(Items.BRICK);
            ResourceKey decorationKey = DecoratedPotPatterns.getPatternFromItem((Item)decorationItem2);
            if (decorationKey == null) {
                return quad;
            }
            TextureAtlasSprite target = (TextureAtlasSprite)ClientUtils.getMinecraft().getTextureAtlas(TextureAtlases.getBlocks()).apply(data.color.getPatternLocation((ResourceKey<DecoratedPotPattern>)decorationKey));
            return PotBakedModel.swapSprite(quad, sprite, target);
        }
        if (spriteName.getNamespace().equals("pottery") && spriteName.getPath().equals(data.type.getIdentifier() + "/" + data.type.getIdentifier(data.color) + "_side") && (decorationItem = DecorationUtils.getDecorationItem(data.decorations, data.facing, quad.getDirection())).isPresent()) {
            TextureAtlasSprite target = (TextureAtlasSprite)ClientUtils.getMinecraft().getTextureAtlas(TextureAtlases.getBlocks()).apply(ResourceLocation.fromNamespaceAndPath((String)"pottery", (String)(data.type.getIdentifier() + "/" + data.type.getIdentifier(data.color) + "_side_decorated")));
            return PotBakedModel.swapSprite(quad, sprite, target);
        }
        return quad;
    }

    private static BakedQuad swapSprite(BakedQuad quad, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite) {
        int[] vertexData = quad.getVertices();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        int vertexSize = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
        int vertices = vertexData.length / vertexSize;
        int uvOffset = BLOCK_VERTEX_DATA_UV_OFFSET / 4;
        float oldWidth = oldSprite.getU1() - oldSprite.getU0();
        float oldHeight = oldSprite.getV1() - oldSprite.getV0();
        float newWidth = newSprite.getU1() - newSprite.getU0();
        float newHeight = newSprite.getV1() - newSprite.getV0();
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float u = newSprite.getU0() + (Float.intBitsToFloat(vertexData[offset]) - oldSprite.getU0()) / oldWidth * newWidth;
            vertexData[offset] = Float.floatToRawIntBits(u);
            float v = newSprite.getV0() + (Float.intBitsToFloat(vertexData[offset + 1]) - oldSprite.getV0()) / oldHeight * newHeight;
            vertexData[offset + 1] = Float.floatToRawIntBits(v);
        }
        return new BakedQuad(vertexData, quad.getTintIndex(), quad.getDirection(), newSprite, quad.isShade());
    }

    private static int findUVOffset(VertexFormat vertexFormat) {
        VertexFormatElement element = null;
        for (int index = 0; index < vertexFormat.getElements().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.getElements().get(index);
            if (el.usage() != VertexFormatElement.Usage.UV) continue;
            element = el;
            break;
        }
        if (element == null) {
            throw new RuntimeException("Expected vertex format to have a UV attribute");
        }
        return vertexFormat.getOffset(element);
    }

    public boolean useAmbientOcclusion() {
        return this.original.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.original.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.original.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.original.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.original.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.original.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.original.getOverrides();
    }

    private record PotData(PotType type, PotColor color, Direction facing, PotDecorations decorations) {
    }
}

