/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.ender_pack.client.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import common.com.cursee.ender_pack.EnderPackClient;
import common.com.cursee.ender_pack.core.block.entity.type.EnderPackBlockEntity;
import common.com.cursee.ender_pack.core.block.type.EnderPackBlock;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class EnderPackBlockEntityRenderer
implements BlockEntityRenderer<EnderPackBlockEntity> {
    private final ModelPart BAG_MODEL;
    private static final double PIXEL = 0.0625;
    private static final double BLOCK = 1.0;

    public EnderPackBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart rootModelPart = context.bakeLayer(EnderPackClient.ENDER_PACK_PLAYER_MODEL_LAYER_LOCATION);
        this.BAG_MODEL = rootModelPart.getChild("ender_pack");
    }

    public void render(EnderPackBlockEntity enderPack, float partialTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        if (!enderPack.hasLevel()) {
            return;
        }
        Direction FACING_DIRECTION = (Direction)enderPack.getBlockState().getValue((Property)EnderPackBlock.FACING);
        Vector3f offset = new Vector3f();
        float rotationDegrees = 0.0f;
        switch (FACING_DIRECTION) {
            case NORTH: {
                offset.set(1.0f, 0.125f, 1.0f);
                rotationDegrees = 180.0f;
                break;
            }
            case EAST: {
                offset.set(0.0f, 0.125f, 1.0f);
                rotationDegrees = 90.0f;
                break;
            }
            case SOUTH: {
                offset.set(0.0f, 0.125f, 0.0f);
                break;
            }
            case WEST: {
                offset.set(1.0f, 0.125f, 0.0f);
                rotationDegrees = 270.0f;
            }
        }
        pose.pushPose();
        pose.translate(offset.x, offset.y, offset.z);
        pose.mulPose(Axis.YP.rotationDegrees(rotationDegrees));
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)EnderPackClient.ENDER_PACK_TEXTURE_LOCATION));
        pose.translate(0.5625, 0.5625, 1.1875);
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        this.BAG_MODEL.render(pose, vertexConsumer, light, overlay);
        pose.popPose();
    }
}

