/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createsandpapers.data;

import com.drmangotea.createsandpapers.CSRegistrate;
import com.drmangotea.createsandpapers.CreateSandpapers;
import com.drmangotea.createsandpapers.ModSandpapers;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateDataProvider;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class CSDatagen {
    public static void gatherData(GatherDataEvent event) {
        CSDatagen.addExtraRegistrateData();
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        generator.addProvider(server, (DataProvider)new CSCraftingProvider(packOutput, lookupProvider));
        event.getGenerator().addProvider(true, (DataProvider)CreateSandpapers.REGISTRATE.setDataProvider(new RegistrateDataProvider((AbstractRegistrate)CreateSandpapers.REGISTRATE, "createsandpapers", event)));
    }

    private static void addExtraRegistrateData() {
        CreateSandpapers.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            CSRegistrate.provideSandpaperLang(langConsumer);
            langConsumer.accept("itemGroup.createsandpapers", "Create: More Sand Papers");
        });
    }

    public static class CSCraftingProvider
    extends RecipeProvider {
        public CSCraftingProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> registries) {
            super(pOutput, registries);
        }

        protected void buildRecipes(RecipeOutput recipeOutput) {
            ModSandpapers[] sandpapers;
            for (ModSandpapers sandpaper : sandpapers = ModSandpapers.values()) {
                CSCraftingProvider.sandPaperRecipe(sandpaper.getName().toLowerCase(), recipeOutput);
            }
        }

        protected static void sandPaperRecipe(String name, RecipeOutput recipeOutput) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)CSRegistrate.getSandpaper(name)).requires((ItemLike)Items.PAPER).requires(CSRegistrate.makesSandpaper(name)).unlockedBy("has_item", RegistrateRecipeProvider.has(CSRegistrate.makesSandpaper(name))).save(recipeOutput, CreateSandpapers.asResource("crafting/" + name + "_sand_paper"));
        }
    }
}

