/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.createsandpapers;

import com.drmangotea.createsandpapers.CreateSandpapers;
import com.drmangotea.createsandpapers.SandPaperEntry;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItem;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.mixin.accessor.AbstractRegistrateAccessor;
import com.simibubi.create.impl.registrate.CreateRegistrateRegistrationCallbackImpl;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateDataProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CSRegistrate
extends AbstractRegistrate<CSRegistrate> {
    private static final Map<RegistryEntry<?, ?>, DeferredHolder<CreativeModeTab, CreativeModeTab>> TAB_LOOKUP = Collections.synchronizedMap(new IdentityHashMap());
    private static final List<String> sandpaperLang = new ArrayList<String>();
    @Nullable
    protected Function<Item, TooltipModifier> currentTooltipModifierFactory;
    protected DeferredHolder<CreativeModeTab, CreativeModeTab> currentTab;

    public static boolean isInCreativeTab(RegistryEntry<?, ?> entry, DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        return TAB_LOOKUP.get(entry) == tab;
    }

    protected CSRegistrate() {
        super("createsandpapers");
    }

    public static CSRegistrate create() {
        return new CSRegistrate();
    }

    public SandPaperEntry sandPaper(String name) {
        return new SandPaperEntry(this, name);
    }

    public CSRegistrate setTooltipModifierFactory(@Nullable Function<Item, TooltipModifier> factory) {
        this.currentTooltipModifierFactory = factory;
        return (CSRegistrate)this.self();
    }

    @Nullable
    public Function<Item, TooltipModifier> getTooltipModifierFactory() {
        return this.currentTooltipModifierFactory;
    }

    @Nullable
    public CSRegistrate setCreativeTab(DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this.currentTab = tab;
        return (CSRegistrate)this.self();
    }

    public DeferredHolder<CreativeModeTab, CreativeModeTab> getCreativeTab() {
        return this.currentTab;
    }

    protected <R, T extends R> RegistryEntry<R, T> accept(String name, ResourceKey<? extends Registry<R>> type, Builder<R, T, ?, ?> builder, NonNullSupplier<? extends T> creator, NonNullFunction<DeferredHolder<R, T>, ? extends RegistryEntry<R, T>> entryFactory) {
        RegistryEntry entry = super.accept(name, type, builder, creator, entryFactory);
        if (type.equals((Object)Registries.ITEM) && this.currentTooltipModifierFactory != null) {
            Function<Item, TooltipModifier> factory = this.currentTooltipModifierFactory;
            this.addRegisterCallback(name, Registries.ITEM, item -> {
                TooltipModifier modifier = (TooltipModifier)factory.apply((Item)item);
                TooltipModifier.REGISTRY.register(item, (Object)modifier);
            });
        }
        if (this.currentTab != null) {
            TAB_LOOKUP.put(entry, this.currentTab);
        }
        for (CreateRegistrateRegistrationCallbackImpl.CallbackImpl callback : CreateRegistrateRegistrationCallbackImpl.CALLBACKS_VIEW) {
            String modId = callback.id().getNamespace();
            String entryId = callback.id().getPath();
            if (!callback.registry().equals(type) || !this.getModid().equals(modId) || !name.equals(entryId)) continue;
            callback.callback().accept(entry.get());
        }
        return entry;
    }

    public ItemEntry<SandPaperItem> sandPaperItem(String name) {
        sandpaperLang.add(name);
        ItemBuilder builder = (ItemBuilder)this.item(name + "_sand_paper", SandPaperItem::new).tag(new TagKey[]{AllTags.AllItemTags.SANDPAPER.tag}).onRegister(s -> ItemDescription.referKey((ItemLike)s, (Supplier)AllItems.SAND_PAPER));
        return builder.register();
    }

    public static Item getSandpaper(String name) {
        return (Item)CreateSandpapers.REGISTRATE.get(name + "_sand_paper", Registries.ITEM).get();
    }

    public static void provideSandpaperLang(BiConsumer<String, String> consumer) {
        for (String name : sandpaperLang) {
            consumer.accept("item.createsandpapers." + name + "_sand_paper.tooltip.summary", "Can be used to _refine materials_. The process can be automated with a Deployer.");
            consumer.accept("item.createsandpapers." + name + "_sand_paper.tooltip.condition1", "When Used");
            consumer.accept("item.createsandpapers." + name + "_sand_paper.tooltip.behaviour1", "Applies polish to items held in the _offhand_ or lying on the _floor_ when _looking at them_");
        }
    }

    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> modTag(Registry<T> registry, String namespace, String path) {
        return CSRegistrate.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static TagKey<Item> modItemTag(String namespace, String path) {
        return CSRegistrate.modTag(BuiltInRegistries.ITEM, namespace, path);
    }

    public static TagKey<Item> makesSandpaper(String name) {
        return CSRegistrate.modItemTag("createsandpapers", "creates_" + name + "_sandpaper");
    }

    @ApiStatus.Internal
    public RegistrateDataProvider setDataProvider(RegistrateDataProvider provider) {
        ((AbstractRegistrateAccessor)this).create$setProvider(provider);
        return provider;
    }
}

