/*
 * Decompiled with CFR 0.152.
 */
package net.yassoudesign.holycube.network;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.yassoudesign.holycube.HolycubeAdditionsYassouMod;
import net.yassoudesign.holycube.procedures.CPTSelectProcedure;
import net.yassoudesign.holycube.procedures.CantonValaisFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.JapanFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.KitsuneselectProcedure;
import net.yassoudesign.holycube.procedures.LoveparisSelectProcedure;
import net.yassoudesign.holycube.procedures.MonacoselectProcedure;
import net.yassoudesign.holycube.procedures.OpenPage1FlagsProcedure;
import net.yassoudesign.holycube.procedures.PrinteFlagProcedure;
import net.yassoudesign.holycube.procedures.SuramaflagSelectionProcedure;
import net.yassoudesign.holycube.procedures.WarringtonFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.WitcherselectProcedure;
import net.yassoudesign.holycube.world.inventory.Flagguipage2Menu;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record Flagguipage2ButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<Flagguipage2ButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"holycube_additions_yassou", (String)"flagguipage_2_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, Flagguipage2ButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new Flagguipage2ButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<Flagguipage2ButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(Flagguipage2ButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                Flagguipage2ButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = Flagguipage2Menu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PrinteFlagProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            JapanFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            WarringtonFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            CantonValaisFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SuramaflagSelectionProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            LoveparisSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            CPTSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            MonacoselectProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            KitsuneselectProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            WitcherselectProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            OpenPage1FlagsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HolycubeAdditionsYassouMod.addNetworkMessage(TYPE, STREAM_CODEC, Flagguipage2ButtonMessage::handleData);
    }
}

