/*
 * Decompiled with CFR 0.152.
 */
package net.yassoudesign.holycube.network;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.yassoudesign.holycube.HolycubeAdditionsYassouMod;
import net.yassoudesign.holycube.procedures.AlgerieFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.AllemagneFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.AlsaceFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.AngleterreFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.BelgiqueFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.BretonflagselectProcedure;
import net.yassoudesign.holycube.procedures.CanadaSelectProcedure;
import net.yassoudesign.holycube.procedures.EsperentoFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.FranceFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.GurlsFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.IleFrFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.ItaleFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.MaliwanflagselectProcedure;
import net.yassoudesign.holycube.procedures.MarocFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.NimbusflagselectProcedure;
import net.yassoudesign.holycube.procedures.NormandFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.OccitaniFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.OpenPage2FlagsProcedure;
import net.yassoudesign.holycube.procedures.PalestineFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.PrinteFlagProcedure;
import net.yassoudesign.holycube.procedures.QuebecFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.SkullFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.StonksFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.SuisseFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.TunisieFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.UsaFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.VenisFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.WhiteFlagSelectProcedure;
import net.yassoudesign.holycube.procedures.WinxFlagSelectProcedure;
import net.yassoudesign.holycube.world.inventory.FlagguiMenu;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record FlagguiButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FlagguiButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"holycube_additions_yassou", (String)"flaggui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlagguiButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new FlagguiButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<FlagguiButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(FlagguiButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                FlagguiButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = FlagguiMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BretonflagselectProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            NimbusflagselectProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            FranceFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            CanadaSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            BelgiqueFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SuisseFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            PalestineFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            AlgerieFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            MarocFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            TunisieFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            UsaFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            AngleterreFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            ItaleFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            AllemagneFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            NormandFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            AlsaceFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 16) {
            QuebecFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 17) {
            IleFrFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 18) {
            VenisFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 19) {
            StonksFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 20) {
            WhiteFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 21) {
            GurlsFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 22) {
            WinxFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 23) {
            MaliwanflagselectProcedure.execute((Entity)entity);
        }
        if (buttonID == 24) {
            SkullFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 25) {
            PrinteFlagProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 26) {
            OccitaniFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 27) {
            EsperentoFlagSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 29) {
            OpenPage2FlagsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HolycubeAdditionsYassouMod.addNetworkMessage(TYPE, STREAM_CODEC, FlagguiButtonMessage::handleData);
    }
}

