/*
 * Decompiled with CFR 0.152.
 */
package net.yassoudesign.holycube.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yassoudesign.holycube.procedures.MaliwanBannerOnBlockRightClickedProcedure;

public class MaliwanBannerBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)2);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public MaliwanBannerBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(1.0f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)14.0, (double)28.0, (double)6.9, (double)18.0, (double)32.0, (double)9.9), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)-5.0, (double)29.0, (double)7.4, (double)21.0, (double)31.0, (double)9.4), MaliwanBannerBlock.box((double)-2.0, (double)28.0, (double)6.9, (double)2.0, (double)32.0, (double)9.9), MaliwanBannerBlock.box((double)-5.0, (double)-11.0, (double)8.1, (double)21.0, (double)28.0, (double)8.7)});
                case Direction.NORTH -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)-2.0, (double)28.0, (double)6.1, (double)2.0, (double)32.0, (double)9.1), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)-5.0, (double)29.0, (double)6.6, (double)21.0, (double)31.0, (double)8.6), MaliwanBannerBlock.box((double)14.0, (double)28.0, (double)6.1, (double)18.0, (double)32.0, (double)9.1), MaliwanBannerBlock.box((double)-5.0, (double)-11.0, (double)7.3, (double)21.0, (double)28.0, (double)7.9)});
                case Direction.EAST -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)6.9, (double)28.0, (double)-2.0, (double)9.9, (double)32.0, (double)2.0), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)7.4, (double)29.0, (double)-5.0, (double)9.4, (double)31.0, (double)21.0), MaliwanBannerBlock.box((double)6.9, (double)28.0, (double)14.0, (double)9.9, (double)32.0, (double)18.0), MaliwanBannerBlock.box((double)8.1, (double)-11.0, (double)-5.0, (double)8.7, (double)28.0, (double)21.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)6.1, (double)28.0, (double)14.0, (double)9.1, (double)32.0, (double)18.0), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)6.6, (double)29.0, (double)-5.0, (double)8.6, (double)31.0, (double)21.0), MaliwanBannerBlock.box((double)6.1, (double)28.0, (double)-2.0, (double)9.1, (double)32.0, (double)2.0), MaliwanBannerBlock.box((double)7.3, (double)-11.0, (double)-5.0, (double)7.9, (double)28.0, (double)21.0)});
            };
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 2) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)14.0, (double)25.6, (double)-0.1, (double)18.0, (double)29.6, (double)2.9), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)-5.0, (double)27.0, (double)0.4, (double)21.0, (double)29.0, (double)2.4), MaliwanBannerBlock.box((double)-2.0, (double)25.6, (double)-0.1, (double)2.0, (double)29.6, (double)2.9), MaliwanBannerBlock.box((double)-5.0, (double)-13.0, (double)1.1, (double)21.0, (double)26.0, (double)1.7), MaliwanBannerBlock.box((double)-4.0, (double)27.0, (double)-7.0, (double)-2.0, (double)29.0, (double)0.4), MaliwanBannerBlock.box((double)18.0, (double)27.0, (double)-7.0, (double)20.0, (double)29.0, (double)0.4)});
                case Direction.NORTH -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)-2.0, (double)25.6, (double)13.1, (double)2.0, (double)29.6, (double)16.1), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)-5.0, (double)27.0, (double)13.6, (double)21.0, (double)29.0, (double)15.6), MaliwanBannerBlock.box((double)14.0, (double)25.6, (double)13.1, (double)18.0, (double)29.6, (double)16.1), MaliwanBannerBlock.box((double)-5.0, (double)-13.0, (double)14.3, (double)21.0, (double)26.0, (double)14.9), MaliwanBannerBlock.box((double)18.0, (double)27.0, (double)15.6, (double)20.0, (double)29.0, (double)23.0), MaliwanBannerBlock.box((double)-4.0, (double)27.0, (double)15.6, (double)-2.0, (double)29.0, (double)23.0)});
                case Direction.EAST -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)-0.1, (double)25.6, (double)-2.0, (double)2.9, (double)29.6, (double)2.0), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)0.4, (double)27.0, (double)-5.0, (double)2.4, (double)29.0, (double)21.0), MaliwanBannerBlock.box((double)-0.1, (double)25.6, (double)14.0, (double)2.9, (double)29.6, (double)18.0), MaliwanBannerBlock.box((double)1.1, (double)-13.0, (double)-5.0, (double)1.7, (double)26.0, (double)21.0), MaliwanBannerBlock.box((double)-7.0, (double)27.0, (double)18.0, (double)0.4, (double)29.0, (double)20.0), MaliwanBannerBlock.box((double)-7.0, (double)27.0, (double)-4.0, (double)0.4, (double)29.0, (double)-2.0)});
                case Direction.WEST -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)13.1, (double)25.6, (double)14.0, (double)16.1, (double)29.6, (double)18.0), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)13.6, (double)27.0, (double)-5.0, (double)15.6, (double)29.0, (double)21.0), MaliwanBannerBlock.box((double)13.1, (double)25.6, (double)-2.0, (double)16.1, (double)29.6, (double)2.0), MaliwanBannerBlock.box((double)14.3, (double)-13.0, (double)-5.0, (double)14.9, (double)26.0, (double)21.0), MaliwanBannerBlock.box((double)15.6, (double)27.0, (double)-4.0, (double)23.0, (double)29.0, (double)-2.0), MaliwanBannerBlock.box((double)15.6, (double)27.0, (double)18.0, (double)23.0, (double)29.0, (double)20.0)});
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)14.0, (double)25.6, (double)-0.1, (double)18.0, (double)29.6, (double)2.9), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)-5.0, (double)27.0, (double)0.4, (double)21.0, (double)29.0, (double)2.4), MaliwanBannerBlock.box((double)-2.0, (double)25.6, (double)-0.1, (double)2.0, (double)29.6, (double)2.9), MaliwanBannerBlock.box((double)-5.0, (double)-13.0, (double)1.1, (double)21.0, (double)26.0, (double)1.7)});
            case Direction.NORTH -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)-2.0, (double)25.6, (double)13.1, (double)2.0, (double)29.6, (double)16.1), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)-5.0, (double)27.0, (double)13.6, (double)21.0, (double)29.0, (double)15.6), MaliwanBannerBlock.box((double)14.0, (double)25.6, (double)13.1, (double)18.0, (double)29.6, (double)16.1), MaliwanBannerBlock.box((double)-5.0, (double)-13.0, (double)14.3, (double)21.0, (double)26.0, (double)14.9)});
            case Direction.EAST -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)-0.1, (double)25.6, (double)-2.0, (double)2.9, (double)29.6, (double)2.0), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)0.4, (double)27.0, (double)-5.0, (double)2.4, (double)29.0, (double)21.0), MaliwanBannerBlock.box((double)-0.1, (double)25.6, (double)14.0, (double)2.9, (double)29.6, (double)18.0), MaliwanBannerBlock.box((double)1.1, (double)-13.0, (double)-5.0, (double)1.7, (double)26.0, (double)21.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)MaliwanBannerBlock.box((double)13.1, (double)25.6, (double)14.0, (double)16.1, (double)29.6, (double)18.0), (VoxelShape[])new VoxelShape[]{MaliwanBannerBlock.box((double)13.6, (double)27.0, (double)-5.0, (double)15.6, (double)29.0, (double)21.0), MaliwanBannerBlock.box((double)13.1, (double)25.6, (double)-2.0, (double)16.1, (double)29.6, (double)2.0), MaliwanBannerBlock.box((double)14.3, (double)-13.0, (double)-5.0, (double)14.9, (double)26.0, (double)21.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        MaliwanBannerOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, blockstate);
        return InteractionResult.SUCCESS;
    }
}

