/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.jei;

import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.foundation.item.ItemHelper;
import fr.iglee42.cmr.CreateMoreRecipes;
import fr.iglee42.cmr.init.CMRRecipeTypes;
import fr.iglee42.cmr.init.CMRRegistries;
import fr.iglee42.cmr.jei.BlockSpoutCategory;
import fr.iglee42.cmr.jei.FanCustomCategory;
import fr.iglee42.cmr.recipes.BlockSpoutingRecipe;
import fr.iglee42.cmr.recipes.CustomFanRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CMRJEI
implements IModPlugin {
    private static final ResourceLocation ID = CreateMoreRecipes.asResource("jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private IIngredientManager ingredientManager;

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory customFan = this.builder(CustomFanRecipe.class).addTypedRecipes(CMRRecipeTypes.CUSTOM_FAN).catalystStack(ProcessingViaFanCategory.getFan((String)"fan_custom")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.DIAMOND).emptyBackground(178, 72).build("fan_custom", FanCustomCategory::new);
        CreateRecipeCategory blockSpout = this.builder(BlockSpoutingRecipe.class).addTypedRecipes(CMRRecipeTypes.BLOCK_SPOUTING).catalystStack(() -> CMRRegistries.BLOCK_SPOUT.asStack()).itemIcon((ItemLike)CMRRegistries.BLOCK_SPOUT.asItem()).emptyBackground(178, 72).build("block_spout", BlockSpoutCategory::new);
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
        registration.addRecipeCatalyst(CMRRegistries.SMITHING_PRESS, new RecipeType[]{RecipeTypes.SMITHING});
    }

    public static void consumeAllRecipes(Consumer<? super RecipeHolder<?>> consumer) {
        Minecraft.getInstance().getConnection().getRecipeManager().getRecipes().forEach(consumer);
    }

    public static <T extends Recipe<?>> void consumeTypedRecipes(Consumer<RecipeHolder<?>> consumer, net.minecraft.world.item.crafting.RecipeType<?> type) {
        List map = Minecraft.getInstance().getConnection().getRecipeManager().getAllRecipesFor(type);
        if (!map.isEmpty()) {
            map.forEach(consumer);
        }
    }

    public static List<RecipeHolder<?>> getTypedRecipes(net.minecraft.world.item.crafting.RecipeType<?> type) {
        ArrayList recipes = new ArrayList();
        CMRJEI.consumeTypedRecipes(recipes::add, type);
        return recipes;
    }

    public static List<RecipeHolder<?>> getTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType<?> type, Predicate<RecipeHolder<?>> exclusionPred) {
        List<RecipeHolder<?>> recipes = CMRJEI.getTypedRecipes(type);
        recipes.removeIf(exclusionPred);
        return recipes;
    }

    public static boolean doInputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        if (recipe1.getIngredients().isEmpty() || recipe2.getIngredients().isEmpty()) {
            return false;
        }
        ItemStack[] matchingStacks = ((Ingredient)recipe1.getIngredients().getFirst()).getItems();
        if (matchingStacks.length == 0) {
            return false;
        }
        return ((Ingredient)recipe2.getIngredients().getFirst()).test(matchingStacks[0]);
    }

    public static boolean doOutputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
        return ItemHelper.sameItem((ItemStack)recipe1.getResultItem((HolderLookup.Provider)registryAccess), (ItemStack)recipe2.getResultItem((HolderLookup.Provider)registryAccess));
    }

    private class CategoryBuilder<T extends Recipe<?>>
    extends CreateRecipeCategory.Builder<T> {
        public CategoryBuilder(Class<? extends T> recipeClass) {
            super(recipeClass);
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            return this.build(CreateMoreRecipes.asResource(name), factory);
        }

        public CreateRecipeCategory<T> build(ResourceLocation id, CreateRecipeCategory.Factory<T> factory) {
            CreateRecipeCategory category = super.build(id, factory);
            CMRJEI.this.allCategories.add(category);
            return category;
        }
    }
}

