/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.cmr.cooler.SnowmanCoolerBlock;
import fr.iglee42.cmr.init.CMRPartials;
import fr.iglee42.cmr.init.CMRRegistries;
import fr.iglee42.cmr.init.CMRSpriteShifts;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class AnimatedSnowmanCooler
extends AnimatedKinetics {
    private SnowmanCoolerBlock.HeatLevel heatLevel;

    public AnimatedSnowmanCooler withHeat(SnowmanCoolerBlock.HeatLevel heatLevel) {
        this.heatLevel = heatLevel;
        return this;
    }

    public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        int scale = 23;
        float offset = (Mth.sin((float)(AnimationTickHolder.getRenderTime() / 16.0f)) + 0.5f) / 16.0f;
        this.blockElement(CMRRegistries.SNOWMAN_COOLER.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale((double)scale).render(graphics);
        PartialModel blaze = this.heatLevel == SnowmanCoolerBlock.HeatLevel.FREEZING ? CMRPartials.SNOWMAN_SUPER_ACTIVE : CMRPartials.SNOWMAN_ACTIVE;
        this.blockElement(blaze).atLocal(1.0, 1.8, 1.0).rotate(0.0, 180.0, 0.0).scale((double)scale).render(graphics);
        matrixStack.scale((float)scale, (float)(-scale), (float)scale);
        matrixStack.translate(0.0, -1.8, 0.0);
        SpriteShiftEntry spriteShift = this.heatLevel == SnowmanCoolerBlock.HeatLevel.FREEZING ? CMRSpriteShifts.SUPER_COOLER_FLAME : CMRSpriteShifts.COOLER_FLAME;
        float spriteWidth = spriteShift.getTarget().getU1() - spriteShift.getTarget().getU0();
        float spriteHeight = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)Minecraft.getInstance().level);
        float speed = 0.03125f + 0.015625f * (float)this.heatLevel.ordinal();
        double vScroll = speed * time;
        vScroll -= Math.floor(vScroll);
        vScroll = vScroll * (double)spriteHeight / 2.0;
        double uScroll = speed * time / 2.0f;
        uScroll -= Math.floor(uScroll);
        uScroll = uScroll * (double)spriteWidth / 2.0;
        CachedBuffers.partial((PartialModel)CMRPartials.SNOWMAN_FLAME, (BlockState)Blocks.AIR.defaultBlockState()).shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll).light(0xF000F0).renderInto(matrixStack, graphics.bufferSource().getBuffer(RenderType.cutoutMipped()));
        matrixStack.popPose();
    }
}

