/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.init;

import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class CMRTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return CMRTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return CMRTags.commonTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return CMRTags.commonTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return CMRTags.commonTag(BuiltInRegistries.FLUID, path);
    }

    public static void init() {
        CMRBlockTags.init();
        CMRItemTags.init();
        CMRFluidTags.init();
        CMREntityTags.init();
        CMRRecipeSerializerTags.init();
    }

    public static final class CMRBlockTags
    extends Enum<CMRBlockTags> {
        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ CMRBlockTags[] $VALUES;

        public static CMRBlockTags[] values() {
            return (CMRBlockTags[])$VALUES.clone();
        }

        public static CMRBlockTags valueOf(String name) {
            return Enum.valueOf(CMRBlockTags.class, name);
        }

        private CMRBlockTags() {
            this(NameSpace.MOD);
        }

        private CMRBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMRBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CMRTags.optionalTag(BuiltInRegistries.BLOCK, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.getItem()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).getBlock());
        }

        public boolean matches(BlockState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ CMRBlockTags[] $values() {
            return new CMRBlockTags[0];
        }

        static {
            $VALUES = CMRBlockTags.$values();
        }
    }

    public static enum CMRItemTags {
        SNOWMAN_COOLER_FUEL_REGULAR(NameSpace.MOD, "snowman_cooler_fuel/regular"),
        SNOWMAN_COOLER_FUEL_SPECIAL(NameSpace.MOD, "snowman_cooler_fuel/special");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private CMRItemTags() {
            this(NameSpace.MOD);
        }

        private CMRItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMRItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CMRTags.optionalTag(BuiltInRegistries.ITEM, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }
    }

    public static final class CMRFluidTags
    extends Enum<CMRFluidTags> {
        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ CMRFluidTags[] $VALUES;

        public static CMRFluidTags[] values() {
            return (CMRFluidTags[])$VALUES.clone();
        }

        public static CMRFluidTags valueOf(String name) {
            return Enum.valueOf(CMRFluidTags.class, name);
        }

        private CMRFluidTags() {
            this(NameSpace.MOD);
        }

        private CMRFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMRFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CMRTags.optionalTag(BuiltInRegistries.FLUID, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.is(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ CMRFluidTags[] $values() {
            return new CMRFluidTags[0];
        }

        static {
            $VALUES = CMRFluidTags.$values();
        }
    }

    public static enum CMREntityTags {
        SNOWMAN_COOLER_CAPTURABLE;

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private CMREntityTags() {
            this(NameSpace.MOD);
        }

        private CMREntityTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMREntityTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMREntityTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMREntityTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CMRTags.optionalTag(BuiltInRegistries.ENTITY_TYPE, id) : TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(EntityType<?> type) {
            return type.is(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.getType());
        }

        private static void init() {
        }
    }

    public static final class CMRRecipeSerializerTags
    extends Enum<CMRRecipeSerializerTags> {
        public final TagKey<RecipeSerializer<?>> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ CMRRecipeSerializerTags[] $VALUES;

        public static CMRRecipeSerializerTags[] values() {
            return (CMRRecipeSerializerTags[])$VALUES.clone();
        }

        public static CMRRecipeSerializerTags valueOf(String name) {
            return Enum.valueOf(CMRRecipeSerializerTags.class, name);
        }

        private CMRRecipeSerializerTags() {
            this(NameSpace.MOD);
        }

        private CMRRecipeSerializerTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRRecipeSerializerTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRRecipeSerializerTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMRRecipeSerializerTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? CMRTags.optionalTag(BuiltInRegistries.RECIPE_SERIALIZER, id) : TagKey.create((ResourceKey)Registries.RECIPE_SERIALIZER, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(RecipeSerializer<?> recipeSerializer) {
            ResourceKey key = (ResourceKey)BuiltInRegistries.RECIPE_SERIALIZER.getResourceKey(recipeSerializer).orElseThrow();
            return ((Holder.Reference)BuiltInRegistries.RECIPE_SERIALIZER.getHolder(key).orElseThrow()).is(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ CMRRecipeSerializerTags[] $values() {
            return new CMRRecipeSerializerTags[0];
        }

        static {
            $VALUES = CMRRecipeSerializerTags.$values();
        }
    }

    public static enum NameSpace {
        MOD("cmr", false, true),
        COMMON("c"),
        CREATE("create");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

