/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.init;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.infrastructure.config.AllConfigs;
import fr.iglee42.cmr.CreateMoreRecipes;
import fr.iglee42.cmr.init.CMRRecipeTypes;
import fr.iglee42.cmr.recipes.CustomFanRecipe;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class CMRFanProcessingTypes
extends AllFanProcessingTypes {
    public static final CustomizableFanType CUSTOM = CMRFanProcessingTypes.register("custom", new CustomizableFanType());
    private static final Map<String, FanProcessingType> LEGACY_NAME_MAP;

    private static <T extends FanProcessingType> T register(String id, T type) {
        Registry.register((Registry)CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)CreateMoreRecipes.asResource(id), type);
        return type;
    }

    @Nullable
    public static FanProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    @ApiStatus.Internal
    public static void init() {
    }

    public static FanProcessingType parseLegacy(String str) {
        FanProcessingType type = CMRFanProcessingTypes.ofLegacyName(str);
        return type != null ? type : FanProcessingType.parse((String)str);
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"CUSTOM", (Object)CUSTOM);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class CustomizableFanType
    implements FanProcessingType {
        private FanProcessingType.AirFlowParticleAccess access;

        public boolean isValidAt(Level level, BlockPos blockPos) {
            Block block = level.getBlockState(blockPos).getBlock();
            return level.getRecipeManager().getAllRecipesFor(CMRRecipeTypes.CUSTOM_FAN.getType()).stream().anyMatch(r -> {
                StandardProcessingRecipe r1 = (StandardProcessingRecipe)r.value();
                CustomFanRecipe r2 = (CustomFanRecipe)r1;
                return r2.getProcessingBlock().contains(block);
            });
        }

        public int getPriority() {
            return 2000;
        }

        public boolean canProcess(ItemStack itemStack, Level level) {
            return false;
        }

        @Nullable
        public List<ItemStack> process(ItemStack itemStack, Level level) {
            return null;
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.random.nextInt(8) != 0) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleTypes.POOF, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess airFlowParticleAccess, RandomSource randomSource) {
            this.access = airFlowParticleAccess;
        }

        public void affectEntity(Entity entity, Level level) {
        }

        public FanProcessingType.AirFlowParticleAccess getAccess() {
            return this.access;
        }

        private boolean canProcess(ItemStack itemStack, Level level, Direction fanDir, BlockPos fanPos, double entityDistance) {
            ItemStackHandler handler = new ItemStackHandler(1);
            handler.setStackInSlot(0, itemStack);
            if (this.isValidAt(level, CreateMoreRecipes.getPosOfCatalyst(fanPos, level, fanDir, (int)entityDistance))) {
                Block block = level.getBlockState(CreateMoreRecipes.getPosOfCatalyst(fanPos, level, fanDir, (int)entityDistance)).getBlock();
                return level.getRecipeManager().getAllRecipesFor(CMRRecipeTypes.CUSTOM_FAN.getType()).stream().anyMatch(r -> {
                    StandardProcessingRecipe r1 = (StandardProcessingRecipe)r.value();
                    CustomFanRecipe r2 = (CustomFanRecipe)r1;
                    return r2.matches(new CustomFanRecipe.CustomFanWrapper(handler), level, block);
                });
            }
            return false;
        }

        public boolean canCustomProcess(ItemEntity entity, FanProcessingType type, Level level, Direction dir, BlockPos fanPos, double entityDistance) {
            CompoundTag compound;
            if (entity.getPersistentData().contains("CreateData") && (compound = entity.getPersistentData().getCompound("CreateData")).contains("Processing")) {
                CompoundTag processing = compound.getCompound("Processing");
                if (AllFanProcessingTypes.parseLegacy((String)processing.getString("Type")) != type) {
                    return this.canProcess(entity.getItem(), entity.level(), dir, fanPos, entityDistance);
                }
                if (processing.getInt("Time") >= 0) {
                    return true;
                }
                if (processing.getInt("Time") == -1) {
                    return false;
                }
            }
            return this.canProcess(entity.getItem(), entity.level(), dir, fanPos, entityDistance);
        }

        @Nullable
        public List<ItemStack> process(ItemStack itemStack, Level level, Direction dir, BlockPos fanPos, double entityDistance) {
            ItemStackHandler handler = new ItemStackHandler(1);
            handler.setStackInSlot(0, itemStack);
            if (this.isValidAt(level, CreateMoreRecipes.getPosOfCatalyst(fanPos, level, dir, (int)entityDistance))) {
                Block block = level.getBlockState(CreateMoreRecipes.getPosOfCatalyst(fanPos, level, dir, (int)entityDistance)).getBlock();
                Optional<RecipeHolder> recipe = level.getRecipeManager().getAllRecipesFor(CMRRecipeTypes.CUSTOM_FAN.getType()).stream().filter(r -> {
                    StandardProcessingRecipe r1 = (StandardProcessingRecipe)r.value();
                    CustomFanRecipe r2 = (CustomFanRecipe)r1;
                    return r2.matches(new CustomFanRecipe.CustomFanWrapper(handler), level, block);
                }).findFirst();
                return recipe.map(recipeRecipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)itemStack, (RecipeHolder)recipeRecipeHolder)).orElse(null);
            }
            return null;
        }

        public boolean applyProcessingEntity(ItemEntity entity, FanProcessingType type, Direction dir, BlockPos fanPos, double entityDistance) {
            if (CustomizableFanType.decrementProcessingTime(entity, type) != 0) {
                return false;
            }
            List<ItemStack> stacks = this.process(entity.getItem(), entity.level(), dir, fanPos, entityDistance);
            if (stacks == null) {
                return false;
            }
            if (stacks.isEmpty()) {
                entity.discard();
                return false;
            }
            entity.setItem(stacks.remove(0));
            for (ItemStack additional : stacks) {
                ItemEntity entityIn = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), additional);
                entityIn.setDeltaMovement(entity.getDeltaMovement());
                entity.level().addFreshEntity((Entity)entityIn);
            }
            return true;
        }

        public TransportedItemStackHandlerBehaviour.TransportedResult applyProcessingHandlers(TransportedItemStack transported, Level world, FanProcessingType type, Direction dir, BlockPos fanPos, int blockDistance) {
            TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            if (transported.processedBy != type) {
                int processingTime;
                transported.processedBy = type;
                int timeModifierForStackSize = (transported.stack.getCount() - 1) / 16 + 1;
                transported.processingTime = processingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
                if (!this.canProcess(transported.stack, world, dir, fanPos, blockDistance)) {
                    transported.processingTime = -1;
                }
                return ignore;
            }
            if (transported.processingTime == -1) {
                return ignore;
            }
            if (transported.processingTime-- > 0) {
                return ignore;
            }
            List<ItemStack> stacks = this.process(transported.stack, world, dir, fanPos, blockDistance);
            if (stacks == null) {
                return ignore;
            }
            ArrayList<TransportedItemStack> transportedStacks = new ArrayList<TransportedItemStack>();
            for (ItemStack additional : stacks) {
                TransportedItemStack newTransported = transported.getSimilar();
                newTransported.stack = additional.copy();
                transportedStacks.add(newTransported);
            }
            return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
        }

        private static int decrementProcessingTime(ItemEntity entity, FanProcessingType type) {
            CompoundTag processing;
            CompoundTag createData;
            CompoundTag nbt = entity.getPersistentData();
            if (!nbt.contains("CreateData")) {
                nbt.put("CreateData", (Tag)new CompoundTag());
            }
            if (!(createData = nbt.getCompound("CreateData")).contains("Processing")) {
                createData.put("Processing", (Tag)new CompoundTag());
            }
            if (!(processing = createData.getCompound("Processing")).contains("Type") || AllFanProcessingTypes.parseLegacy((String)processing.getString("Type")) != type) {
                ResourceLocation key = CreateBuiltInRegistries.FAN_PROCESSING_TYPE.getKey((Object)type);
                if (key == null) {
                    throw new IllegalArgumentException("Could not get id for FanProcessingType " + String.valueOf(type) + "!");
                }
                processing.putString("Type", key.toString());
                int timeModifierForStackSize = (entity.getItem().getCount() - 1) / 16 + 1;
                int processingTime = (Integer)AllConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
                processing.putInt("Time", processingTime);
            }
            int value = processing.getInt("Time") - 1;
            processing.putInt("Time", value);
            return value;
        }
    }
}

