/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.cooler;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.processing.burner.ScrollInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.SimpleTickableVisual;
import fr.iglee42.cmr.cooler.SnowmanCoolerBlock;
import fr.iglee42.cmr.cooler.SnowmanCoolerBlockEntity;
import fr.iglee42.cmr.cooler.SnowmanCoolerRenderer;
import fr.iglee42.cmr.init.CMRPartials;
import fr.iglee42.cmr.init.CMRSpriteShifts;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class SnowmanCoolerVisual
extends AbstractBlockEntityVisual<SnowmanCoolerBlockEntity>
implements SimpleDynamicVisual,
SimpleTickableVisual {
    private SnowmanCoolerBlock.HeatLevel heatLevel = SnowmanCoolerBlock.HeatLevel.IDLE;
    private final TransformedInstance head;
    private final boolean isInert;
    @Nullable
    private ScrollInstance flame;
    @Nullable
    private TransformedInstance goggles;
    @Nullable
    private TransformedInstance hat;
    private boolean validBlockAbove;

    public SnowmanCoolerVisual(VisualizationContext ctx, SnowmanCoolerBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        this.validBlockAbove = blockEntity.isValidBlockAbove();
        PartialModel blazeModel = SnowmanCoolerRenderer.getBlazeModel(this.heatLevel, this.validBlockAbove);
        this.isInert = blazeModel == CMRPartials.SNOWMAN_INERT;
        this.head = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)blazeModel)).createInstance();
        this.head.light(0xF000F0);
        this.animate(partialTick);
    }

    public void tick(TickableVisual.Context context) {
        ((SnowmanCoolerBlockEntity)this.blockEntity).tickAnimation();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        if (!this.isVisible(ctx.frustum()) || this.doDistanceLimitThisFrame(ctx)) {
            return;
        }
        this.animate(ctx.partialTick());
    }

    private void animate(float partialTicks) {
        boolean hatPresent;
        float animation = ((SnowmanCoolerBlockEntity)this.blockEntity).headAnimation.getValue(partialTicks) * 0.175f;
        boolean validBlockAbove = animation > 0.125f;
        SnowmanCoolerBlock.HeatLevel heatLevel = ((SnowmanCoolerBlockEntity)this.blockEntity).getHeatLevelForRender();
        if (validBlockAbove != this.validBlockAbove || heatLevel != this.heatLevel) {
            this.validBlockAbove = validBlockAbove;
            PartialModel blazeModel = SnowmanCoolerRenderer.getBlazeModel(heatLevel, validBlockAbove);
            this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)blazeModel)).stealInstance((Instance)this.head);
            this.heatLevel = heatLevel;
        }
        if (validBlockAbove && this.flame == null) {
            this.setupFlameInstance();
        } else if (!validBlockAbove && this.flame != null) {
            this.flame.delete();
            this.flame = null;
        }
        if (((SnowmanCoolerBlockEntity)this.blockEntity).goggles && this.goggles == null) {
            this.goggles = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)(this.isInert ? AllPartialModels.BLAZE_GOGGLES_SMALL : AllPartialModels.BLAZE_GOGGLES))).createInstance();
            this.goggles.light(0xF000F0);
        } else if (!((SnowmanCoolerBlockEntity)this.blockEntity).goggles && this.goggles != null) {
            this.goggles.delete();
            this.goggles = null;
        }
        boolean bl = hatPresent = ((SnowmanCoolerBlockEntity)this.blockEntity).hat || ((SnowmanCoolerBlockEntity)this.blockEntity).stockKeeper;
        if (hatPresent && this.hat == null) {
            this.hat = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)(((SnowmanCoolerBlockEntity)this.blockEntity).stockKeeper ? AllPartialModels.LOGISTICS_HAT : AllPartialModels.TRAIN_HAT))).createInstance();
            this.hat.light(0xF000F0);
        } else if (!hatPresent && this.hat != null) {
            this.hat.delete();
            this.hat = null;
        }
        int hashCode = ((Object)((Object)((SnowmanCoolerBlockEntity)this.blockEntity))).hashCode();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)this.level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(SnowmanCoolerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = Mth.sin((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float headY = offset - animation * 0.75f;
        float horizontalAngle = AngleHelper.rad((double)((SnowmanCoolerBlockEntity)this.blockEntity).headAngle.getValue(partialTicks));
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.head.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(headY)).translate(0.5f)).rotateY(horizontalAngle).translateBack(0.5f)).setChanged();
        if (this.goggles != null) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.goggles.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(headY + 0.5f)).translate(0.5f)).rotateY(horizontalAngle).translateBack(0.5f)).setChanged();
        }
        if (this.hat != null) {
            ((TransformedInstance)((TransformedInstance)this.hat.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(headY)).translateY(0.75f);
            ((TransformedInstance)this.hat.rotateCentered(horizontalAngle + (float)Math.PI, Direction.UP)).translate(0.5f, 0.0f, 0.5f).light(0xF000F0);
            this.hat.setChanged();
        }
    }

    private void setupFlameInstance() {
        this.flame = (ScrollInstance)this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial((PartialModel)CMRPartials.SNOWMAN_FLAME)).createInstance();
        this.flame.position((Vec3i)this.getVisualPosition()).light(0xF000F0);
        SpriteShiftEntry spriteShift = this.heatLevel == SnowmanCoolerBlock.HeatLevel.FREEZING ? CMRSpriteShifts.SUPER_COOLER_FLAME : CMRSpriteShifts.COOLER_FLAME;
        float spriteWidth = spriteShift.getTarget().getU1() - spriteShift.getTarget().getU0();
        float spriteHeight = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
        float speed = 0.03125f + 0.015625f * (float)this.heatLevel.ordinal();
        this.flame.speedU = speed / 2.0f;
        this.flame.speedV = speed;
        this.flame.scaleU = spriteWidth / 2.0f;
        this.flame.scaleV = spriteHeight / 2.0f;
        this.flame.diffU = spriteShift.getTarget().getU0() - spriteShift.getOriginal().getU0();
        this.flame.diffV = spriteShift.getTarget().getV0() - spriteShift.getOriginal().getV0();
    }

    public void updateLight(float partialTick) {
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    protected void _delete() {
        this.head.delete();
        if (this.flame != null) {
            this.flame.delete();
        }
        if (this.goggles != null) {
            this.goggles.delete();
        }
        if (this.hat != null) {
            this.hat.delete();
        }
    }
}

