/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.cooler;

import com.simibubi.create.AllSoundEvents;
import fr.iglee42.cmr.cooler.SnowmanCoolerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

@EventBusSubscriber
public class SnowmanCoolerHandler {
    @SubscribeEvent
    public static void onThrowableImpact(ProjectileImpactEvent event) {
        SnowmanCoolerHandler.thrownEggsGetEatenByBurner(event);
    }

    public static void thrownEggsGetEatenByBurner(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof Snowball)) {
            return;
        }
        if (event.getRayTraceResult().getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity blockEntity = projectile.level().getBlockEntity(BlockPos.containing((Position)event.getRayTraceResult().getLocation()));
        if (!(blockEntity instanceof SnowmanCoolerBlockEntity)) {
            return;
        }
        event.setCanceled(true);
        projectile.setDeltaMovement(Vec3.ZERO);
        projectile.discard();
        Level world = projectile.level();
        if (world.isClientSide) {
            return;
        }
        SnowmanCoolerBlockEntity heater = (SnowmanCoolerBlockEntity)blockEntity;
        if (!heater.isCreative() && heater.activeFuel != SnowmanCoolerBlockEntity.FuelType.SPECIAL) {
            heater.activeFuel = SnowmanCoolerBlockEntity.FuelType.NORMAL;
            heater.remainingBurnTime = Mth.clamp((int)(heater.remainingBurnTime + 80), (int)0, (int)10000);
            heater.updateBlockState();
            heater.notifyUpdate();
        }
        AllSoundEvents.BLAZE_MUNCH.playOnServer(world, (Vec3i)heater.getBlockPos());
    }
}

