/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.cooler;

import fr.iglee42.cmr.init.CMRRegistries;
import fr.iglee42.cmr.init.CMRTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EmptyCoolerBlockItem
extends BlockItem {
    public EmptyCoolerBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity be = world.getBlockEntity(pos);
        Player player = context.getPlayer();
        if (!(be instanceof SpawnerBlockEntity)) {
            return super.useOn(context);
        }
        BaseSpawner spawner = ((SpawnerBlockEntity)be).getSpawner();
        List<SpawnData> possibleSpawns = spawner.spawnPotentials.unwrap().stream().map(WeightedEntry.Wrapper::data).toList();
        if (possibleSpawns.isEmpty()) {
            possibleSpawns = new ArrayList<SpawnData>();
            possibleSpawns.add(spawner.nextSpawnData);
        }
        for (SpawnData e : possibleSpawns) {
            Optional optionalEntity = EntityType.by((CompoundTag)e.entityToSpawn());
            if (optionalEntity.isEmpty() || !CMRTags.CMREntityTags.SNOWMAN_COOLER_CAPTURABLE.matches((EntityType)optionalEntity.get())) continue;
            EmptyCoolerBlockItem.spawnCaptureEffects(world, VecHelper.getCenterOf((Vec3i)pos));
            if (world.isClientSide || player == null) {
                return InteractionResult.SUCCESS;
            }
            this.giveBurnerItemTo(player, context.getItemInHand(), context.getHand());
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResult interactLivingEntity(ItemStack heldItem, Player player, LivingEntity entity, InteractionHand hand) {
        if (!CMRTags.CMREntityTags.SNOWMAN_COOLER_CAPTURABLE.matches((Entity)entity)) {
            return InteractionResult.PASS;
        }
        Level world = player.level();
        EmptyCoolerBlockItem.spawnCaptureEffects(world, entity.position());
        if (world.isClientSide) {
            return InteractionResult.FAIL;
        }
        this.giveBurnerItemTo(player, heldItem, hand);
        entity.discard();
        return InteractionResult.FAIL;
    }

    protected void giveBurnerItemTo(Player player, ItemStack heldItem, InteractionHand hand) {
        ItemStack filled = CMRRegistries.SNOWMAN_COOLER.asStack();
        if (!player.isCreative()) {
            heldItem.shrink(1);
        }
        if (heldItem.isEmpty()) {
            player.setItemInHand(hand, filled);
            return;
        }
        player.getInventory().placeItemBackInInventory(filled);
    }

    public static void spawnCaptureEffects(Level world, Vec3 vec) {
        if (world.isClientSide) {
            for (int i = 0; i < 40; ++i) {
                Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)world.random, (float)0.125f);
                world.addParticle((ParticleOptions)ParticleTypes.ITEM_SNOWBALL, vec.x, vec.y, vec.z, motion.x, motion.y, motion.z);
                world.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, vec.x, vec.y, vec.z, motion.x, motion.y, motion.z);
                Vec3 circle = motion.multiply(1.0, 0.0, 1.0).normalize().scale(0.5);
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, circle.x, vec.y, circle.z, 0.0, -0.125, 0.0);
            }
            return;
        }
        BlockPos soundPos = BlockPos.containing((Position)vec);
        world.playSound(null, soundPos, SoundEvents.SNOW_GOLEM_HURT, SoundSource.HOSTILE, 0.25f, 0.75f);
        world.playSound(null, soundPos, SoundEvents.BUCKET_FILL_POWDER_SNOW, SoundSource.HOSTILE, 0.5f, 0.75f);
    }
}

