/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.blockspout;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import fr.iglee42.cmr.init.CMRRecipeTypes;
import fr.iglee42.cmr.init.CMRRegistries;
import fr.iglee42.cmr.recipes.BlockSpoutingRecipe;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BlockSpoutBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public static final int TIME = 100;
    public int processingTicks = -1;
    public boolean sendSplash;
    SmartFluidTankBehaviour tank;
    public BlockSpoutingRecipe recipe;

    public BlockSpoutBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CMRRegistries.BLOCK_SPOUT_BE.get(), (be, context) -> {
            if (context != Direction.DOWN) {
                return be.tank.getCapability();
            }
            return null;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        if (this.processingTicks >= 0) {
            --this.processingTicks;
            this.notifyUpdate();
        }
        if (this.processingTicks > 7 && this.processingTicks < 93) {
            this.sendSplash = true;
            this.notifyUpdate();
        }
        if (this.processingTicks == 7 && this.recipe != null) {
            this.level.destroyBlock(this.worldPosition.below(2), false);
            BlockState transformedBlock = this.recipe.transformBlock(this.level.getBlockState(this.worldPosition.below(2)));
            this.level.setBlock(this.worldPosition.below(2), transformedBlock, 3);
            this.recipe.rollResults().forEach(stack -> Block.popResource((Level)this.level, (BlockPos)this.worldPosition.below(2), (ItemStack)stack));
            FluidStack stack2 = this.getCurrentFluidInTank().copy();
            stack2.shrink(this.recipe.getRequiredFluid().getRequiredAmount());
            this.tank.getPrimaryHandler().setFluid(stack2);
            this.notifyUpdate();
            this.recipe = null;
        }
        if (this.recipe == null) {
            Optional<BlockSpoutingRecipe> foundRecipe = this.level.getRecipeManager().getAllRecipesFor(CMRRecipeTypes.BLOCK_SPOUTING.getType()).stream().filter(r -> {
                BlockSpoutingRecipe bsr = (BlockSpoutingRecipe)((ProcessingRecipe)r.value());
                return bsr.testBlock(this.level.getBlockState(this.worldPosition.below(2))) && bsr.getRequiredFluid().test(this.getCurrentFluidInTank());
            }).map(r -> (BlockSpoutingRecipe)((ProcessingRecipe)r.value())).findFirst();
            if (foundRecipe.isEmpty()) {
                this.recipe = null;
                return;
            }
            this.recipe = foundRecipe.get();
            this.processingTicks = 100;
        }
    }

    protected void spawnParticles() {
        if (this.isVirtual()) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        vec = vec.subtract(0.0, 2.0, 0.0);
        BlockParticleOption particle = new BlockParticleOption(ParticleTypes.BLOCK, this.getCurrentFluidInTank().getFluid().defaultFluidState().createLegacyBlock());
        for (int i = 0; i < 2; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)this.level.random, (float)1.5f);
            m = new Vec3(m.x, Math.abs(m.y), m.z);
            this.level.addAlwaysVisibleParticle((ParticleOptions)particle, vec.x, vec.y, vec.z, m.x, m.y, m.z);
        }
    }

    private FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    protected void write(CompoundTag compoundTag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compoundTag, registries, clientPacket);
        compoundTag.putInt("ProcessingTicks", this.processingTicks);
        if (this.sendSplash && clientPacket) {
            compoundTag.putBoolean("Splash", true);
            this.sendSplash = false;
        }
    }

    protected void read(CompoundTag compoundTag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compoundTag, registries, clientPacket);
        this.processingTicks = compoundTag.getInt("ProcessingTicks");
        if (!clientPacket) {
            return;
        }
        if (compoundTag.contains("Splash")) {
            this.spawnParticles();
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().expandTowards(0.0, -2.0, 0.0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition, null));
    }
}

