/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.autosmithing;

import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import fr.iglee42.cmr.autosmithing.SmithingBehaviour;
import fr.iglee42.cmr.autosmithing.SmithingPressBlock;
import fr.iglee42.cmr.autosmithing.SmithingPressBlockEntity;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SmithingPressVisual
extends ShaftVisual<SmithingPressBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance pressHead = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)AllPartialModels.MECHANICAL_PRESS_HEAD)).createInstance();

    public SmithingPressVisual(VisualizationContext context, SmithingPressBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        Quaternionf q = Axis.YP.rotationDegrees(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.getValue(SmithingPressBlock.HORIZONTAL_FACING))));
        this.pressHead.rotation((Quaternionfc)q);
        this.transformModels(partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels(ctx.partialTick());
    }

    private void transformModels(float pt) {
        float renderedHeadOffset = this.getRenderedHeadOffset(pt);
        this.pressHead.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    private float getRenderedHeadOffset(float pt) {
        SmithingBehaviour smithingBehaviour = ((SmithingPressBlockEntity)this.blockEntity).getSmithingBehaviour();
        return smithingBehaviour.getRenderedHeadOffset(pt) * 19.0f / 16.0f;
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.pressHead});
    }

    protected void _delete() {
        super._delete();
        this.pressHead.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.pressHead);
    }
}

