/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.autosmithing;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.cmr.autosmithing.SmithingBehaviour;
import fr.iglee42.cmr.init.CMRRegistries;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class SmithingPressBlockEntity
extends BasinOperatingBlockEntity
implements SmithingBehaviour.SmithingBehaviourSpecifics {
    private static final Object smithingRecipesKey = new Object();
    public SmithingBehaviour smithingBehaviour;
    protected SmartInventory templateInv = new SmartInventory(1, (SyncedBlockEntity)this);
    protected SmartInventory additionInv = new SmartInventory(1, (SyncedBlockEntity)this);

    public SmithingPressBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CMRRegistries.SMITHING_PRESS_BE.get(), (be, context) -> {
            if (Objects.equals(context, Direction.UP) || Objects.equals(context, Direction.DOWN)) {
                return be.templateInv;
            }
            return be.additionInv;
        });
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, -1.5, 0.0).expandTowards(0.0, 1.0, 0.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.smithingBehaviour = new SmithingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.smithingBehaviour);
    }

    public void destroy() {
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.templateInv);
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.additionInv);
        super.destroy();
    }

    public SmithingBehaviour getSmithingBehaviour() {
        return this.smithingBehaviour;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("Template", (Tag)this.templateInv.serializeNBT(registries));
        compound.put("Addition", (Tag)this.additionInv.serializeNBT(registries));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.templateInv.deserializeNBT(registries, compound.getCompound("Template"));
        this.additionInv.deserializeNBT(registries, compound.getCompound("Addition"));
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<RecipeHolder<SmithingRecipe>> recipe = this.getRecipe(input.stack);
        if (!recipe.isPresent()) {
            return false;
        }
        ItemStack output = ((SmithingRecipe)recipe.get().value()).assemble((RecipeInput)new SmithingRecipeInput(this.templateInv.getStackInSlot(0), input.stack.copyWithCount(1), this.additionInv.getStackInSlot(0)), (HolderLookup.Provider)this.level.registryAccess());
        if (simulate) {
            return !output.isEmpty();
        }
        this.smithingBehaviour.particleItems.add(input.stack);
        if (!output.isEmpty()) {
            this.templateInv.extractItem(0, 1, false);
            this.additionInv.extractItem(0, 1, false);
            outputList.add(output);
            return true;
        }
        return false;
    }

    @Override
    public void onPressingCompleted() {
        this.basinChecker.scheduleUpdate();
    }

    public Optional<RecipeHolder<SmithingRecipe>> getRecipe(ItemStack item) {
        if (this.level == null) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().getRecipeFor(RecipeType.SMITHING, (RecipeInput)new SmithingRecipeInput(this.templateInv.getStackInSlot(0), item, this.additionInv.getStackInSlot(0)), this.level);
    }

    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> recipe) {
        return recipe.value() instanceof SmithingRecipe;
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    protected Object getRecipeCacheKey() {
        return smithingRecipesKey;
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    protected void onBasinRemoved() {
        this.smithingBehaviour.particleItems.clear();
        this.smithingBehaviour.running = false;
        this.smithingBehaviour.runningTicks = 0;
        this.sendData();
    }

    protected boolean isRunning() {
        return this.smithingBehaviour.running;
    }

    protected Optional<CreateAdvancement> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.COMPACTING);
    }

    public SmartInventory getInvForSide(Direction direction) {
        if (direction.equals((Object)Direction.UP) || direction.equals((Object)Direction.DOWN)) {
            return this.templateInv;
        }
        return this.additionInv;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.templateInv.isEmpty()) {
            CreateLang.translate((String)"tooltip.deployer.contains", (Object[])new Object[]{Component.translatable((String)this.templateInv.getStackInSlot(0).getDescriptionId()).getString(), this.templateInv.getStackInSlot(0).getCount()}).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        if (!this.additionInv.isEmpty()) {
            CreateLang.translate((String)"tooltip.deployer.contains", (Object[])new Object[]{Component.translatable((String)this.additionInv.getStackInSlot(0).getDescriptionId()).getString(), this.additionInv.getStackInSlot(0).getCount()}).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

