/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.autosmithing;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.processing.basin.BasinBlock;
import com.simibubi.create.foundation.block.IBE;
import fr.iglee42.cmr.autosmithing.SmithingPressBlockEntity;
import fr.iglee42.cmr.init.CMRRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmithingPressBlock
extends HorizontalKineticBlock
implements IBE<SmithingPressBlockEntity> {
    public SmithingPressBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext && ((EntityCollisionContext)context).getEntity() instanceof Player) {
            return AllShapes.CASING_14PX.get(Direction.DOWN);
        }
        return AllShapes.MECHANICAL_PROCESSOR_SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !BasinBlock.isBasin((LevelReader)worldIn, (BlockPos)pos.below());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction prefferedSide = this.getPreferredHorizontalFacing(context);
        if (prefferedSide != null) {
            return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)prefferedSide);
        }
        return super.getStateForPlacement(context);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldByPlayer = stack.copy();
        if (AllItems.WRENCH.is((Object)heldByPlayer)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            ItemStack heldByDeployer = be.getInvForSide(hitResult.getDirection()).getItem(0);
            if (heldByDeployer.isEmpty() && heldByPlayer.isEmpty()) {
                return;
            }
            if (be.getInvForSide(hitResult.getDirection()).equals(be.templateInv) && !heldByPlayer.isEmpty() && level.getRecipeManager().getAllRecipesFor(RecipeType.SMITHING).stream().noneMatch(r -> ((SmithingRecipe)r.value()).isTemplateIngredient(heldByPlayer))) {
                return;
            }
            if (be.getInvForSide(hitResult.getDirection()).equals(be.additionInv) && !heldByPlayer.isEmpty() && level.getRecipeManager().getAllRecipesFor(RecipeType.SMITHING).stream().noneMatch(r -> ((SmithingRecipe)r.value()).isAdditionIngredient(heldByPlayer))) {
                return;
            }
            player.setItemInHand(hand, heldByDeployer);
            be.getInvForSide(hitResult.getDirection()).setItem(0, heldByPlayer);
            be.sendData();
        });
        return ItemInteractionResult.SUCCESS;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public Class<SmithingPressBlockEntity> getBlockEntityClass() {
        return SmithingPressBlockEntity.class;
    }

    public BlockEntityType<? extends SmithingPressBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CMRRegistries.SMITHING_PRESS_BE.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

