/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr;

import com.mojang.logging.LogUtils;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.RegistrateDistExecutor;
import fr.iglee42.cmr.autosmithing.SmithingPressBlockEntity;
import fr.iglee42.cmr.blockspout.BlockSpoutBlockEntity;
import fr.iglee42.cmr.init.CMRArmInteractionPointTypes;
import fr.iglee42.cmr.init.CMRCreativeModeTabs;
import fr.iglee42.cmr.init.CMRFanProcessingTypes;
import fr.iglee42.cmr.init.CMRPartials;
import fr.iglee42.cmr.init.CMRRecipeTypes;
import fr.iglee42.cmr.init.CMRRegistries;
import fr.iglee42.cmr.init.CMRSpriteShifts;
import fr.iglee42.cmr.init.CMRTags;
import fr.iglee42.cmr.ponder.CMRPonderPlugin;
import java.util.HashMap;
import java.util.Map;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="cmr")
public class CreateMoreRecipes {
    public static final String MODID = "cmr";
    public static final String coldId = "cooled";
    public static final String freezeId = "frozen";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"cmr").defaultCreativeTab((ResourceKey)null);
    public static final Map<HeatCondition, String> CUSTOM_HEAT_CONDITIONS = new HashMap<HeatCondition, String>();

    public CreateMoreRecipes(IEventBus modEventBus) {
        REGISTRATE.registerEventListeners(modEventBus);
        CMRTags.init();
        CMRRegistries.register();
        CMRRecipeTypes.register(modEventBus);
        CMRSpriteShifts.init();
        CMRCreativeModeTabs.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::registerEvent);
        modEventBus.addListener(SmithingPressBlockEntity::registerCapabilities);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::clientSetup);
        }
        RegistrateDistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> CMRPartials::init);
    }

    public static ResourceLocation asResource(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void clientSetup(FMLClientSetupEvent event) {
        PonderIndex.addPlugin((PonderPlugin)new CMRPonderPlugin());
    }

    private void registerEvent(RegisterEvent event) {
        CMRFanProcessingTypes.init();
        CMRArmInteractionPointTypes.init();
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        BlockSpoutBlockEntity.registerCapabilities(event);
    }

    public static BlockPos getPosOfCatalyst(BlockPos fanPos, Level level, Direction direction, int distance) {
        BlockPos currentPos = fanPos;
        BlockEntity blockEntity = level.getBlockEntity(fanPos);
        if (!(blockEntity instanceof EncasedFanBlockEntity)) {
            return fanPos;
        }
        EncasedFanBlockEntity fan = (EncasedFanBlockEntity)blockEntity;
        if (!fan.getAirCurrent().pushing) {
            int i = 0;
            while ((float)i < fan.getAirCurrent().maxDistance) {
                if (!CMRFanProcessingTypes.CUSTOM.isValidAt(level, currentPos)) {
                    currentPos = fanPos.relative(direction, i);
                }
                ++i;
            }
        } else {
            for (int i = distance; i > 0; --i) {
                if (CMRFanProcessingTypes.CUSTOM.isValidAt(level, currentPos)) continue;
                currentPos = fanPos.relative(direction, i);
            }
        }
        return currentPos;
    }
}

