/*
 * Decompiled with CFR 0.152.
 */
package io.gadjalin.holywrench.mixin;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={DebugStickItem.class})
public abstract class MixinDebugStickItem
extends Item {
    private static final Set<Property<?>> allowedProperties = Set.of(BlockStateProperties.ATTACHED, BlockStateProperties.BOTTOM, BlockStateProperties.IN_WALL, BlockStateProperties.LIT, BlockStateProperties.OPEN, BlockStateProperties.AXIS, BlockStateProperties.SNOWY, BlockStateProperties.UP, BlockStateProperties.DOWN, BlockStateProperties.NORTH, BlockStateProperties.EAST, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.FACING, BlockStateProperties.FACING_HOPPER, BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.ORIENTATION, BlockStateProperties.ATTACH_FACE, BlockStateProperties.BELL_ATTACHMENT, BlockStateProperties.NORTH_WALL, BlockStateProperties.EAST_WALL, BlockStateProperties.SOUTH_WALL, BlockStateProperties.WEST_WALL, BlockStateProperties.HALF, BlockStateProperties.RAIL_SHAPE, BlockStateProperties.RAIL_SHAPE_STRAIGHT, BlockStateProperties.AGE_1, BlockStateProperties.LEVEL, BlockStateProperties.ROTATION_16, BlockStateProperties.DOOR_HINGE, BlockStateProperties.SLAB_TYPE, BlockStateProperties.STAIRS_SHAPE, BlockStateProperties.BAMBOO_LEAVES, BlockStateProperties.TILT, BlockStateProperties.DRIPSTONE_THICKNESS, BlockStateProperties.CRAFTING);
    private static final Map<Property<?>, Predicate<BlockState>> specialStates = Map.of(BlockStateProperties.FACING, state -> {
        if (state.is(Blocks.CHEST) || state.is(Blocks.TRAPPED_CHEST)) {
            return state.getValue((Property)ChestBlock.TYPE) != ChestType.LEFT || state.getValue((Property)ChestBlock.TYPE) != ChestType.RIGHT;
        }
        if (state.is(Blocks.PISTON) || state.is(Blocks.STICKY_PISTON)) {
            return (Boolean)state.getValue((Property)PistonBaseBlock.EXTENDED) == false;
        }
        return true;
    }, BlockStateProperties.UP, state -> !(state.getBlock() instanceof WallBlock), BlockStateProperties.SLAB_TYPE, state -> state.getValue((Property)SlabBlock.TYPE) != SlabType.DOUBLE, BlockStateProperties.AGE_1, state -> state.is(Blocks.BAMBOO), BlockStateProperties.LEVEL, state -> state.is(Blocks.LIGHT));
    private static final Map<Property<?>, Predicate<Object>> specialProperties = Map.of(BlockStateProperties.SLAB_TYPE, value -> !value.equals(SlabType.DOUBLE));

    public MixinDebugStickItem(Item.Properties properties) {
        super(properties);
    }

    @Shadow
    private static void message(Player player, Component messageComponent) {
    }

    public Component getName(ItemStack stack) {
        return Component.literal((String)"HolyWrench");
    }

    @Overwrite
    private boolean handleInteraction(Player player, BlockState stateClicked, LevelAccessor accessor, BlockPos pos, boolean shouldCycleState, ItemStack debugStack) {
        Holder holder = stateClicked.getBlockHolder();
        StateDefinition stateDefinition = ((Block)holder.value()).getStateDefinition();
        Collection<Property<?>> collection = player.isCreative() ? stateDefinition.getProperties() : MixinDebugStickItem.filterStateProperties(stateDefinition.getProperties(), stateClicked);
        if (collection.isEmpty()) {
            MixinDebugStickItem.message(player, (Component)Component.translatable((String)(this.getDescriptionId() + ".empty"), (Object[])new Object[]{holder.getRegisteredName()}));
            return false;
        }
        DebugStickState debugstickstate = (DebugStickState)debugStack.get(DataComponents.DEBUG_STICK_STATE);
        if (debugstickstate == null) {
            return false;
        }
        Property<?> property = (Property<?>)debugstickstate.properties().get(holder);
        if (shouldCycleState) {
            if (property == null || !collection.contains(property)) {
                property = collection.iterator().next();
            }
            BlockState blockstate = player.isCreative() ? MixinDebugStickItem.cycleState(stateClicked, property, player.isSecondaryUseActive()) : MixinDebugStickItem.cycleFilteredState(stateClicked, property, player.isSecondaryUseActive());
            accessor.setBlock(pos, blockstate, 18);
            MixinDebugStickItem.message(player, (Component)Component.translatable((String)(this.getDescriptionId() + ".update"), (Object[])new Object[]{property.getName(), MixinDebugStickItem.getNameHelper(blockstate, property)}));
        } else {
            if (!collection.contains(property)) {
                property = collection.iterator().next();
            }
            property = MixinDebugStickItem.getRelative(collection, property, player.isSecondaryUseActive());
            debugStack.set(DataComponents.DEBUG_STICK_STATE, (Object)debugstickstate.withProperty(holder, property));
            MixinDebugStickItem.message(player, (Component)Component.translatable((String)(this.getDescriptionId() + ".select"), (Object[])new Object[]{property.getName(), MixinDebugStickItem.getNameHelper(stateClicked, property)}));
        }
        return true;
    }

    private static <T extends Comparable<T>> BlockState cycleFilteredState(BlockState state, Property<T> property, boolean backwards) {
        return (BlockState)state.setValue(property, MixinDebugStickItem.getRelative(MixinDebugStickItem.filterPropertyValues(property.getPossibleValues(), property), state.getValue(property), backwards));
    }

    @Shadow
    private static <T extends Comparable<T>> BlockState cycleState(BlockState state, Property<T> property, boolean backwards) {
        return null;
    }

    @Shadow
    private static <T> T getRelative(Iterable<T> allowedValues, @Nullable T currentValue, boolean backwards) {
        return null;
    }

    @Shadow
    private static <T extends Comparable<T>> String getNameHelper(BlockState state, Property<T> property) {
        return null;
    }

    private static Collection<Property<?>> filterStateProperties(Collection<Property<?>> properties, BlockState stateClicked) {
        return properties.stream().filter(property -> allowedProperties.contains(property) && specialStates.getOrDefault(property, state -> true).test(stateClicked)).collect(Collectors.toList());
    }

    private static <T> Collection<T> filterPropertyValues(Collection<T> values, Property<?> property) {
        return values.stream().filter(value -> specialProperties.getOrDefault(property, obj -> true).test(value)).collect(Collectors.toList());
    }
}

