/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.worldgen.feature;

import com.mojang.serialization.Codec;
import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.block.GhastlingIncubatorBlock;
import dev.nweaver.happyghastmod.init.BlockInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GhastlingIncubatorFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int MAX_SEARCH_RADIUS = 15;
    private static final int PLACEMENT_RADIUS = 5;
    private static final float SPAWN_CHANCE = 1.0f;
    private static final int MIN_DISTANCE_BETWEEN_INCUBATORS = 10;

    public GhastlingIncubatorFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        if (HappyGhastMod.LOGGER.isTraceEnabled()) {
            HappyGhastMod.LOGGER.trace("GhastlingIncubatorFeature.place called at {}", (Object)origin);
        }
        if (random.nextFloat() >= 1.0f) {
            return false;
        }
        List<BlockPos> bonePositions = this.findAllBoneBlocks(level, origin, 15);
        if (bonePositions.isEmpty()) {
            if (HappyGhastMod.LOGGER.isTraceEnabled()) {
                HappyGhastMod.LOGGER.trace("No bone blocks found near {}", (Object)origin);
            }
            return false;
        }
        if (HappyGhastMod.LOGGER.isDebugEnabled()) {
            HappyGhastMod.LOGGER.debug("Found {} bone blocks near {}", (Object)bonePositions.size(), (Object)origin);
        }
        int startIndex = random.nextInt(bonePositions.size());
        for (int i = 0; i < bonePositions.size(); ++i) {
            BlockPos placePos;
            int index = (startIndex + i) % bonePositions.size();
            BlockPos bonePos = bonePositions.get(index);
            if (this.hasIncubatorNearby(level, bonePos, 10)) {
                if (!HappyGhastMod.LOGGER.isTraceEnabled()) continue;
                HappyGhastMod.LOGGER.trace("Skipping bone at {} - another incubator already exists nearby", (Object)bonePos);
                continue;
            }
            List<BlockPos> validPositions = this.findValidPlacementPositions(level, bonePos, 5);
            if (validPositions.isEmpty() || !this.placeIncubator(level, placePos = validPositions.get(random.nextInt(validPositions.size())))) continue;
            return true;
        }
        if (HappyGhastMod.LOGGER.isDebugEnabled()) {
            HappyGhastMod.LOGGER.debug("Could not find suitable placement position for incubator near any bone block");
        }
        return false;
    }

    private boolean hasIncubatorNearby(WorldGenLevel level, BlockPos center, int radius) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                    if (!level.getBlockState((BlockPos)mutablePos).is((Block)BlockInit.GHASTLING_INCUBATOR.get())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List<BlockPos> findAllBoneBlocks(WorldGenLevel level, BlockPos center, int maxRadius) {
        ArrayList<BlockPos> bonePositions = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int r = 3; r <= maxRadius; r += 3) {
            int found = 0;
            int sqRadius = r * r;
            for (int y = -r; y <= r; ++y) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        if (x * x + y * y + z * z > sqRadius) continue;
                        mutablePos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                        if (!level.getBlockState((BlockPos)mutablePos).is(Blocks.BONE_BLOCK)) continue;
                        bonePositions.add(mutablePos.immutable());
                        if (++found < 5) continue;
                        return bonePositions;
                    }
                }
            }
            if (!bonePositions.isEmpty()) break;
        }
        return bonePositions;
    }

    private List<BlockPos> findValidPlacementPositions(WorldGenLevel level, BlockPos bonePos, int radius) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos belowPos = new BlockPos.MutableBlockPos();
        int sqRadius = radius * radius;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > sqRadius) continue;
                    mutablePos.set(bonePos.getX() + x, bonePos.getY() + y, bonePos.getZ() + z);
                    belowPos.set(mutablePos.getX(), mutablePos.getY() - 1, mutablePos.getZ());
                    if (!level.isEmptyBlock((BlockPos)mutablePos) || !this.isSuitableGround(level, (BlockPos)belowPos)) continue;
                    validPositions.add(mutablePos.immutable());
                    if (validPositions.size() < 10) continue;
                    return validPositions;
                }
            }
        }
        return validPositions;
    }

    private boolean isSuitableGround(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.is(Blocks.SOUL_SAND) || state.is(Blocks.SOUL_SOIL);
    }

    private boolean placeIncubator(WorldGenLevel level, BlockPos pos) {
        boolean success = level.setBlock(pos, ((GhastlingIncubatorBlock)((Object)BlockInit.GHASTLING_INCUBATOR.get())).defaultBlockState(), 3);
        if (success) {
            HappyGhastMod.LOGGER.info("\u2713 GhastlingIncubatorFeature successfully placed at {}", (Object)pos);
        } else {
            HappyGhastMod.LOGGER.warn("\u2717 Failed to place GhastlingIncubatorFeature at {}", (Object)pos);
        }
        return success;
    }
}

