/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record SyncCustomHarnessPayload(String harnessId, String harnessName, String creatorName, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomPacketPayload.Type<SyncCustomHarnessPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"happyghastmod", (String)"sync_custom_harness"));
    public static final StreamCodec<ByteBuf, SyncCustomHarnessPayload> STREAM_CODEC = new StreamCodec<ByteBuf, SyncCustomHarnessPayload>(){

        public void encode(ByteBuf byteBuf, SyncCustomHarnessPayload payload) {
            this.writeString(byteBuf, payload.harnessId());
            this.writeString(byteBuf, payload.harnessName());
            this.writeString(byteBuf, payload.creatorName());
            this.writeNullableByteArray(byteBuf, payload.saddleTextureData());
            this.writeNullableByteArray(byteBuf, payload.glassesTextureData());
            this.writeNullableByteArray(byteBuf, payload.accessoryTextureData());
        }

        public SyncCustomHarnessPayload decode(ByteBuf byteBuf) {
            String harnessId = this.readString(byteBuf);
            String harnessName = this.readString(byteBuf);
            String creatorName = this.readString(byteBuf);
            byte[] saddleTextureData = this.readNullableByteArray(byteBuf);
            byte[] glassesTextureData = this.readNullableByteArray(byteBuf);
            byte[] accessoryTextureData = this.readNullableByteArray(byteBuf);
            return new SyncCustomHarnessPayload(harnessId, harnessName, creatorName, saddleTextureData, glassesTextureData, accessoryTextureData);
        }

        private void writeString(ByteBuf buffer, String str) {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(bytes.length);
            buffer.writeBytes(bytes);
        }

        private String readString(ByteBuf buffer) {
            int length = buffer.readInt();
            byte[] bytes = new byte[length];
            buffer.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }

        private void writeNullableByteArray(ByteBuf buffer, byte[] data) {
            if (data == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.writeInt(data.length);
                buffer.writeBytes(data);
            }
        }

        private byte[] readNullableByteArray(ByteBuf buffer) {
            boolean hasData = buffer.readBoolean();
            if (hasData) {
                int length = buffer.readInt();
                byte[] data = new byte[length];
                buffer.readBytes(data);
                return data;
            }
            return null;
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncCustomHarnessPayload payload, IPayloadContext context) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            context.enqueueWork(() -> ClientCustomHarnessManager.registerCustomHarness(payload.harnessId(), payload.harnessName(), payload.creatorName(), payload.saddleTextureData(), payload.glassesTextureData(), payload.accessoryTextureData()));
        }
    }
}

