/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.custom.CustomHarnessManager;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record RegisterCustomHarnessPayload(String harnessId, String harnessName, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomPacketPayload.Type<RegisterCustomHarnessPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"happyghastmod", (String)"register_custom_harness"));
    public static final StreamCodec<ByteBuf, RegisterCustomHarnessPayload> STREAM_CODEC = new StreamCodec<ByteBuf, RegisterCustomHarnessPayload>(){

        public void encode(ByteBuf byteBuf, RegisterCustomHarnessPayload payload) {
            this.writeString(byteBuf, payload.harnessId());
            this.writeString(byteBuf, payload.harnessName());
            this.writeNullableByteArray(byteBuf, payload.saddleTextureData());
            this.writeNullableByteArray(byteBuf, payload.glassesTextureData());
            this.writeNullableByteArray(byteBuf, payload.accessoryTextureData());
        }

        public RegisterCustomHarnessPayload decode(ByteBuf byteBuf) {
            String harnessId = this.readString(byteBuf);
            String harnessName = this.readString(byteBuf);
            byte[] saddleTextureData = this.readNullableByteArray(byteBuf);
            byte[] glassesTextureData = this.readNullableByteArray(byteBuf);
            byte[] accessoryTextureData = this.readNullableByteArray(byteBuf);
            return new RegisterCustomHarnessPayload(harnessId, harnessName, saddleTextureData, glassesTextureData, accessoryTextureData);
        }

        private void writeString(ByteBuf buffer, String str) {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            buffer.writeInt(bytes.length);
            buffer.writeBytes(bytes);
        }

        private String readString(ByteBuf buffer) {
            int length = buffer.readInt();
            byte[] bytes = new byte[length];
            buffer.readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }

        private void writeNullableByteArray(ByteBuf buffer, byte[] data) {
            if (data == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.writeInt(data.length);
                buffer.writeBytes(data);
            }
        }

        private byte[] readNullableByteArray(ByteBuf buffer) {
            boolean hasData = buffer.readBoolean();
            if (hasData) {
                int length = buffer.readInt();
                byte[] data = new byte[length];
                buffer.readBytes(data);
                return data;
            }
            return null;
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RegisterCustomHarnessPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            block6: {
                Player player = context.player();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!CustomHarnessManager.isSinglePlayerServer(serverPlayer.getServer())) {
                        LOGGER.info("Custom harness registration blocked in multiplayer from player {}", (Object)serverPlayer.getName().getString());
                        serverPlayer.sendSystemMessage((Component)Component.literal((String)"Custom harness creation is currently only available in single-player mode."));
                        return;
                    }
                    try {
                        boolean success = CustomHarnessManager.registerCustomHarness(payload.harnessId(), payload.harnessName(), payload.saddleTextureData(), payload.glassesTextureData(), payload.accessoryTextureData(), serverPlayer);
                        if (success) {
                            CustomHarnessManager.giveCustomHarnessToPlayer(payload.harnessId(), serverPlayer);
                            break block6;
                        }
                        serverPlayer.sendSystemMessage((Component)Component.literal((String)"Failed to register custom harness. Check server logs."));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error processing custom harness registration from player {}: {}", (Object)serverPlayer.getName().getString(), (Object)e.getMessage(), (Object)e);
                        serverPlayer.sendSystemMessage((Component)Component.literal((String)"An error occurred while registering the custom harness."));
                    }
                } else {
                    LOGGER.warn("Received RegisterCustomHarnessPayload from non-server player or null player context.");
                }
            }
        });
    }
}

