/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.network.ClientNetworkHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record OpenHarnessCreatorPayload(boolean isSinglePlayer) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomPacketPayload.Type<OpenHarnessCreatorPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"happyghastmod", (String)"open_harness_creator"));
    public static final StreamCodec<ByteBuf, OpenHarnessCreatorPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, OpenHarnessCreatorPayload::isSinglePlayer, OpenHarnessCreatorPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(OpenHarnessCreatorPayload payload, IPayloadContext context) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            context.enqueueWork(() -> {
                if (payload.isSinglePlayer()) {
                    ClientNetworkHandler.openHarnessCreatorGui();
                } else {
                    LOGGER.info("Custom harness creator is disabled in multiplayer");
                }
            });
        }
    }
}

