/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.entity.HappyGhast;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record OpenGhastInventoryPayload(int entityId) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomPacketPayload.Type<OpenGhastInventoryPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"happyghastmod", (String)"open_ghast_inventory"));
    public static final StreamCodec<ByteBuf, OpenGhastInventoryPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, OpenGhastInventoryPayload::entityId, OpenGhastInventoryPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(OpenGhastInventoryPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverPlayer.level() == null) {
                    LOGGER.warn("Player level is null when processing OpenGhastInventoryPayload");
                    return;
                }
                Entity entity = serverPlayer.level().getEntity(payload.entityId());
                if (entity == null) {
                    LOGGER.warn("Could not find entity with ID {} for player {}", (Object)payload.entityId(), (Object)serverPlayer.getName().getString());
                    return;
                }
                if (!(entity instanceof HappyGhast)) {
                    LOGGER.warn("Entity with ID {} is not a HappyGhast", (Object)payload.entityId());
                    return;
                }
                HappyGhast ghast = (HappyGhast)entity;
                if (!ghast.isAlive()) {
                    LOGGER.debug("Cannot open inventory for dead ghast");
                    return;
                }
                if (!ghast.hasPassenger((Entity)serverPlayer)) {
                    LOGGER.debug("Player {} is not riding ghast {}", (Object)serverPlayer.getName().getString(), (Object)payload.entityId());
                    return;
                }
                LOGGER.debug("Opening inventory for ghast {} and player {}", (Object)payload.entityId(), (Object)serverPlayer.getName().getString());
                ghast.getInventoryComponent().openInventory((Player)serverPlayer);
            } else {
                LOGGER.warn("Received OpenGhastInventoryPayload from non-server player or null player context.");
            }
        });
    }
}

